/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TappedInputStream
extends FilterInputStream {
    private final ReadHandler handler;

    public TappedInputStream(InputStream stream, ReadHandler handler) {
        super(stream);
        Check.notNull(handler, "handler");
        this.handler = handler;
    }

    @Override
    public int read() throws IOException {
        int val = super.read();
        if (val != -1) {
            this.handler.handleRead((byte)val);
        }
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readCount = super.read(b);
        if (readCount != -1) {
            this.handler.handleRead(b, readCount);
        }
        return readCount;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readCount = super.read(b, off, len);
        if (readCount != -1) {
            this.handler.handleRead(b, off, len, readCount);
        }
        return readCount;
    }

    public static interface ReadHandler {
        public void handleRead(byte var1) throws IOException;

        public void handleRead(byte[] var1, int var2) throws IOException;

        public void handleRead(byte[] var1, int var2, int var3, int var4) throws IOException;
    }
}

