/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.chunkingcodec;

import java.text.MessageFormat;

public class ByteArray {
    public static void putBytes(byte[] dest, int off, byte[] source) {
        ByteArray.putBytes(dest, off, source, 0, source.length);
    }

    public static void putBytes(byte[] dest, int destOff, byte[] source, int sourceOff, int len) {
        ByteArray.testCapacity(dest, destOff, len);
        System.arraycopy(source, sourceOff, dest, destOff, len);
    }

    public static byte[] getBytes(byte[] buf, int off, int len) {
        ByteArray.testCapacity(buf, off, len);
        byte[] value = new byte[len];
        System.arraycopy(buf, off, value, 0, len);
        return value;
    }

    public static void putInt32(byte[] buf, int off, int value) {
        ByteArray.testCapacity(buf, off, 4);
        buf[off + 0] = (byte)((value & 0xFF000000) >> 24);
        buf[off + 1] = (byte)((value & 0xFF0000) >> 16);
        buf[off + 2] = (byte)((value & 0xFF00) >> 8);
        buf[off + 3] = (byte)((value & 0xFF) >> 0);
    }

    public static int getInt32(byte[] buf, int off) {
        ByteArray.testCapacity(buf, off, 4);
        return (buf[off + 0] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | (buf[off + 3] & 0xFF) << 0;
    }

    public static void putUnsignedInt32(byte[] buf, int off, long value) {
        ByteArray.testCapacity(buf, off, 4);
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new RuntimeException("Can't add unsigned int32 to buffer, out of range");
        }
        buf[off + 0] = (byte)((value & 0xFFFFFFFFFF000000L) >> 24);
        buf[off + 1] = (byte)((value & 0xFF0000L) >> 16);
        buf[off + 2] = (byte)((value & 0xFF00L) >> 8);
        buf[off + 3] = (byte)((value & 0xFFL) >> 0);
    }

    public static long getUnsignedInt32(byte[] buf, int off) {
        ByteArray.testCapacity(buf, off, 4);
        return (long)(buf[off + 0] & 0xFF) << 24 | (long)(buf[off + 1] & 0xFF) << 16 | (long)(buf[off + 2] & 0xFF) << 8 | (long)(buf[off + 3] & 0xFF) << 0;
    }

    public static void putInt16(byte[] buf, int off, short value) {
        ByteArray.testCapacity(buf, off, 2);
        buf[off + 0] = (byte)((value & 0xFF00) >> 8);
        buf[off + 1] = (byte)((value & 0xFF) >> 0);
    }

    public static short getInt16(byte[] buf, int off) {
        ByteArray.testCapacity(buf, off, 2);
        return (short)((buf[off + 0] & 0xFF) << 8 | (buf[off + 1] & 0xFF) << 0);
    }

    public static void putUnsignedInt16(byte[] buf, int off, int value) {
        ByteArray.testCapacity(buf, off, 2);
        if (value < 0 || value > 65535) {
            throw new RuntimeException("Can't add unsigned int16 to buffer, out of range");
        }
        buf[off + 0] = (byte)((value & 0xFF00) >> 8);
        buf[off + 1] = (byte)((value & 0xFF) >> 0);
    }

    public static int getUnsignedInt16(byte[] buf, int off) {
        ByteArray.testCapacity(buf, off, 2);
        return (buf[off + 0] & 0xFF) << 8 | (buf[off + 1] & 0xFF) << 0;
    }

    private static void testCapacity(byte[] buf, int off, int size) {
        if (off + size > buf.length) {
            String messageFormat = "Can't read {0} bytes from buffer, length: {1}, offset: {2}";
            String message = MessageFormat.format("Can't read {0} bytes from buffer, length: {1}, offset: {2}", size, buf.length, off);
            throw new ArrayIndexOutOfBoundsException(message);
        }
    }
}

