/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.xml;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.xml.DocumentBuilderCache;
import com.microsoft.tfs.util.xml.XMLException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMCreateUtils {
    private static final DocumentBuilderCache cache = new DocumentBuilderCache();
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final int NONE = 0;
    public static final int NO_CLOSE = 1;

    public static Document newDocument(String name) {
        return DOMCreateUtils.newDocumentNS(null, null, name);
    }

    public static Document newDocument(DocumentBuilder builder, String name) {
        return DOMCreateUtils.newDocumentNS(builder, null, name);
    }

    public static Document newDocumentNS(String namespaceURI, String qualifiedName) {
        return DOMCreateUtils.newDocumentNS(null, namespaceURI, qualifiedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocumentNS(DocumentBuilder builder, String namespaceURI, String qualifiedName) {
        boolean useCache;
        boolean bl = useCache = builder == null;
        if (useCache) {
            builder = cache.takeDocumentBuilder();
        }
        try {
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(namespaceURI, qualifiedName, null);
            return document;
        }
        finally {
            if (useCache) {
                cache.releaseDocumentBuilder(builder);
            }
        }
    }

    public static Document newDocumentWithDocType(String docTypeQualifiedName, String docTypePublicId, String docTypeSystemId, String namespaceURI, String qualifiedName) {
        return DOMCreateUtils.newDocumentWithDocType(null, docTypeQualifiedName, docTypePublicId, docTypeSystemId, namespaceURI, qualifiedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocumentWithDocType(DocumentBuilder builder, String docTypeQualifiedName, String docTypePublicId, String docTypeSystemId, String namespaceURI, String qualifiedName) {
        boolean useCache;
        boolean bl = useCache = builder == null;
        if (useCache) {
            builder = cache.takeDocumentBuilder();
        }
        try {
            DOMImplementation implementation = builder.getDOMImplementation();
            DocumentType doctype = implementation.createDocumentType(docTypeQualifiedName, docTypePublicId, docTypeSystemId);
            Document document = implementation.createDocument(namespaceURI, qualifiedName, doctype);
            return document;
        }
        finally {
            if (useCache) {
                cache.releaseDocumentBuilder(builder);
            }
        }
    }

    public static Document parseFile(File file, String encoding) {
        return DOMCreateUtils.parseFile(null, file, encoding);
    }

    public static Document parseFile(DocumentBuilder builder, File file, String encoding) {
        InputStream inputStream;
        Check.notNull(file, "file");
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new XMLException(e);
        }
        inputStream = new BufferedInputStream(inputStream);
        return DOMCreateUtils.parseStream(builder, inputStream, encoding, 0);
    }

    public static Document parseStream(InputStream inputStream, String encoding) {
        return DOMCreateUtils.parseStream(null, inputStream, encoding, 0);
    }

    public static Document parseStream(InputStream inputStream, String encoding, int flags) {
        return DOMCreateUtils.parseStream(null, inputStream, encoding, flags);
    }

    public static Document parseStream(DocumentBuilder builder, InputStream inputStream, String encoding) {
        return DOMCreateUtils.parseStream(builder, inputStream, encoding, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseStream(DocumentBuilder builder, InputStream inputStream, String encoding, int flags) {
        Check.notNull(inputStream, "inputStream");
        try {
            InputSource input = new InputSource(inputStream);
            if (encoding != null) {
                input.setEncoding(encoding);
            }
            Document document = DOMCreateUtils.parse(builder, input);
            return document;
        }
        finally {
            if ((1 & flags) == 0) {
                IOUtils.closeSafely(inputStream);
            }
        }
    }

    public static Document parseReader(Reader reader) {
        return DOMCreateUtils.parseReader(null, reader, 0);
    }

    public static Document parseReader(Reader reader, int flags) {
        return DOMCreateUtils.parseReader(null, reader, flags);
    }

    public static Document parseReader(DocumentBuilder builder, Reader reader) {
        return DOMCreateUtils.parseReader(builder, reader, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseReader(DocumentBuilder builder, Reader reader, int flags) {
        Check.notNull(reader, "reader");
        try {
            InputSource input = new InputSource(reader);
            Document document = DOMCreateUtils.parse(builder, input);
            return document;
        }
        finally {
            if ((1 & flags) == 0) {
                IOUtils.closeSafely(reader);
            }
        }
    }

    public static Document parseString(String xml) {
        return DOMCreateUtils.parseString(null, xml);
    }

    public static Document parseString(DocumentBuilder builder, String xml) {
        Check.notNull(xml, "xml");
        return DOMCreateUtils.parseReader(builder, new StringReader(xml), 1);
    }

    public static Document parse(InputSource input) {
        return DOMCreateUtils.parse(null, input);
    }

    public static Document parse(DocumentBuilder builder, InputSource input) {
        boolean useCache;
        Check.notNull(input, "input");
        boolean bl = useCache = builder == null;
        if (useCache) {
            builder = cache.takeDocumentBuilder();
        }
        try {
            Document document = builder.parse(input);
            return document;
        }
        catch (SAXException e) {
            throw new XMLException(e);
        }
        catch (IOException e) {
            throw new XMLException(e);
        }
        finally {
            if (useCache) {
                cache.releaseDocumentBuilder(builder);
            }
        }
    }
}

