/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.checks;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FieldMatcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/api/checks/FieldMatcherImpl;", "Lorg/sonarsource/kotlin/api/checks/FieldMatcher;", "names", "", "", "qualifiers", "definingTypes", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "matches", "", "node", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "matchesDefiningType", "matchesQualifiers", "sonar-kotlin-api"})
@SourceDebugExtension(value={"SMAP\nFieldMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldMatcher.kt\norg/sonarsource/kotlin/api/checks/FieldMatcherImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1747#2,3:87\n*S KotlinDebug\n*F\n+ 1 FieldMatcher.kt\norg/sonarsource/kotlin/api/checks/FieldMatcherImpl\n*L\n83#1:87,3\n*E\n"})
final class FieldMatcherImpl
implements FieldMatcher {
    @NotNull
    private final Set<String> names;
    @NotNull
    private final Set<String> qualifiers;
    @NotNull
    private final Set<String> definingTypes;

    public FieldMatcherImpl(@NotNull Set<String> names2, @NotNull Set<String> qualifiers, @NotNull Set<String> definingTypes) {
        Intrinsics.checkNotNullParameter(names2, "names");
        Intrinsics.checkNotNullParameter(qualifiers, "qualifiers");
        Intrinsics.checkNotNullParameter(definingTypes, "definingTypes");
        this.names = names2;
        this.qualifiers = qualifiers;
        this.definingTypes = definingTypes;
    }

    @Override
    public boolean matches(@NotNull KtNameReferenceExpression node, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(bindingContext2, "bindingContext");
        return (this.names.isEmpty() || this.names.contains(node.getReferencedName())) && this.matchesQualifiers(node, bindingContext2) && this.matchesDefiningType(node, bindingContext2);
    }

    private final boolean matchesQualifiers(KtNameReferenceExpression node, BindingContext bindingContext2) {
        if (this.qualifiers.isEmpty()) {
            return true;
        }
        DeclarationDescriptor declarationDescriptor = ApiExtensionsKt.getContainingDeclaration(node, bindingContext2);
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor receiverClassDescriptor = declarationDescriptor;
        return this.qualifiers.contains(DescriptorUtilsKt.getFqNameSafe(receiverClassDescriptor).asString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchesDefiningType(KtNameReferenceExpression node, BindingContext bindingContext2) {
        ClassifierDescriptor it;
        if (this.definingTypes.isEmpty()) {
            return true;
        }
        DeclarationDescriptor declarationDescriptor = ApiExtensionsKt.getContainingDeclaration(node, bindingContext2);
        if (!(declarationDescriptor instanceof ClassifierDescriptor)) return false;
        ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)declarationDescriptor;
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor receiverClassDescriptor = classifierDescriptor;
        if (this.definingTypes.contains(DescriptorUtilsKt.getFqNameSafe(receiverClassDescriptor).asString())) return true;
        Iterable $this$any$iv = SequencesKt.toList(DescriptorUtilsKt.getAllSuperClassifiers(receiverClassDescriptor));
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ClassifierDescriptor)element$iv;
            boolean bl = false;
        } while (!this.definingTypes.contains(DescriptorUtilsKt.getFqNameSafe(it).asString()));
        return true;
    }
}

