/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.performance.measure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DurationMeasure {
    private String name;
    private long calls;
    private long durationNanos;
    @Nullable
    private Map<String, DurationMeasure> childrenMap;

    public DurationMeasure(String name) {
        this(name, 0L, 0L, null);
    }

    public DurationMeasure(String name, long calls, long durationNanos, @Nullable Map<String, DurationMeasure> childrenMap) {
        this.name = name;
        this.calls = calls;
        this.durationNanos = durationNanos;
        this.childrenMap = childrenMap;
    }

    public void addCalls(long callsToAdd, long durationNanosToAdd) {
        this.calls += callsToAdd;
        this.durationNanos += durationNanosToAdd;
    }

    public DurationMeasure getOrCreateChild(String name) {
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap<String, DurationMeasure>();
        }
        return this.childrenMap.computeIfAbsent(name, DurationMeasure::new);
    }

    public DurationMeasure addOrMerge(DurationMeasure child) {
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap<String, DurationMeasure>();
        }
        return this.childrenMap.merge(child.name(), child, DurationMeasure::merge);
    }

    public DurationMeasure merge(DurationMeasure measure) {
        if (!this.name.equals(measure.name)) {
            throw new IllegalStateException("Incompatible name '" + this.name + "' and '" + measure.name + "'");
        }
        this.durationNanos += measure.durationNanos;
        this.calls += measure.calls;
        for (DurationMeasure child : measure.children()) {
            this.addOrMerge(child);
        }
        return this;
    }

    public String name() {
        return this.name;
    }

    public long calls() {
        return this.calls;
    }

    public long durationNanos() {
        return this.durationNanos;
    }

    public void subtractDuration(long durationNanosToSubtract) {
        this.durationNanos -= durationNanosToSubtract;
    }

    public DurationMeasure remove(String childName) {
        if (this.childrenMap == null) {
            return null;
        }
        return this.childrenMap.remove(childName);
    }

    public DurationMeasure get(String childName) {
        if (this.childrenMap == null) {
            return null;
        }
        return this.childrenMap.get(childName);
    }

    public Collection<DurationMeasure> children() {
        return this.childrenMap != null ? this.childrenMap.values() : Collections.emptyList();
    }

    public Collection<DurationMeasure> sortedChildren() {
        ArrayList<DurationMeasure> sortedList = new ArrayList<DurationMeasure>(this.children());
        sortedList.sort(Comparator.comparing(DurationMeasure::name));
        return sortedList;
    }

    public boolean hasChildren() {
        return this.childrenMap == null || this.childrenMap.isEmpty();
    }

    public DurationMeasure copy() {
        HashMap<String, DurationMeasure> childrenMapCopy = null;
        if (this.childrenMap != null) {
            childrenMapCopy = new HashMap<String, DurationMeasure>();
            for (DurationMeasure child : this.childrenMap.values()) {
                childrenMapCopy.put(child.name, child.copy());
            }
        }
        return new DurationMeasure(this.name, this.calls, this.durationNanos, childrenMapCopy);
    }

    public void recursiveMergeOnUpperLevel(String targetChildName) {
        ArrayList delayedActions = new ArrayList();
        this.children().forEach(child -> child.recursiveMergeOnUpperLevel(this, targetChildName, delayedActions));
        delayedActions.forEach(Runnable::run);
    }

    private void recursiveMergeOnUpperLevel(DurationMeasure parent2, String targetChildName, List<Runnable> delayedActions) {
        if (this.childrenMap != null) {
            DurationMeasure childToMove = this.childrenMap.get(targetChildName);
            if (childToMove != null) {
                delayedActions.add(() -> {
                    this.remove(childToMove.name);
                    this.durationNanos -= childToMove.durationNanos;
                    parent2.addOrMerge(childToMove);
                });
            }
            this.children().forEach(child -> child.recursiveMergeOnUpperLevel(this, targetChildName, delayedActions));
        }
    }

    public void rename(String name) {
        this.name = name;
    }
}

