Avoid changing the loop variable inside the body of a `for` loop.

# Why is This a Problem?
Changing the loop variable inside the body of a `for` loop can cause confusion and potential bugs.

# How Can I Resolve This?
Put the loop variable change inside the header of the loop.

## Example (Before)

```cs
for (int i = 0; i < 100;) {
  // do something
  i++;
}
```

## Example (After)

```cs
for (int i = 0; i < 100; i++) {
  // do something
}
```