Using C-style array declarations in Java does not match Java coding conventions. Prefer Java-style declarations for better readability and consistency in the codebase.

# What Does This Check Look For?

This check identifies occurrences where arrays in Java are declared using the C-style syntax.

# Why is This a Problem?

Using C-style array declarations, such as `int array[]`, while correct, diverges from the Java convention of declaring arrays with the type first, followed by the brackets, as in `int[] array`. This inconsistency can lead to confusion and decrease the comprehensibility of the code. Java strongly emphasizes readability and consistency, thus adhering to its conventions is important for maintaining clear and understandable code.

# How Can I Resolve This?

Convert all C-style array declarations to the Java conventional style. This means changing declarations from `type variableName[]` to `type[] variableName`. This approach not only aligns with Java’s conventions but also enhances code readability and maintainability. By consistently following Java's syntactical conventions, you ensure that your code is more accessible to other Java developers.

# Examples

## Non-Compliant

```java
int array[];     // non-compliant: C-style array declaration.
```

## Compliant

```java
int[] array;     // compliant: Java-style array declaration.
```
