Requires `===` and `!==` in place of `==` and `!=`

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
{{ 'null' == test }}
   ~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [attr.disabled]="test != 'undefined' && null == '3'"></div>
                      ~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div *ngIf="test == true || test1 !== undefined"></div>
            ~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ one != '02' ? c > d : 'hey!' }}
   ~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ a === b && 1 == b ? c > d : 'hey!' }}
              ~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ c > d ? a != b : 'hey!' }}
           ~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ c > d ? 'hey!' : a == false }}
                    ~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ undefined == test1 && a === b ? (c > d ? d != '0' : v === 4) : 'hey!' }}
                                            ~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ undefined != test1 }}
   ~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
{{ a === 1 }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div [class.testing]="b === false">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *ngIf="c === test">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div *appShow="(d == null && e === null && (f | lowercase) == undefined) || g === undefined">
```

</details>
