Disallow aliasing `this`.


Assigning a variable to `this` instead of properly using arrow lambdas may be a symptom of pre-ES6 practices
or not managing scope well.

## Examples

<!--tabs-->

### ❌ Incorrect

```js
const self = this;

setTimeout(function () {
  self.doWork();
});
```

### ✅ Correct

```js
setTimeout(() => {
  this.doWork();
});
```

## When Not To Use It

If you need to assign `this` to variables, you shouldn’t use this rule.
