When writing `if`, `else`, `while`, `do-while`, and `for` statements, the body can be a single statement instead of a block. It can be useful to enforce a consistent location for these single statements.

For example, some developers avoid writing code like this:

```js
if (foo)
  bar();
```

If another developer attempts to add `baz();` to the `if` statement, they might mistakenly change the code to

```js
if (foo)
  bar();
  baz(); // this line is not in the `if` statement!
```

To avoid this issue, one might require all single-line `if` statements to appear directly after the conditional, without a linebreak:

```js
if (foo) bar();
```

## Rule Details

This rule aims to enforce a consistent location for single-line statements.

Note that this rule does not enforce the usage of single-line statements in general. If you would like to disallow single-line statements, use the [`curly`](https://eslint.org/docs/rules/curly) rule instead.

## References

- https://jscs-dev.github.io/rule/requireNewlineBeforeSingleStatementsInIf
