### SCS0021 - Request Validation Disabled (Configuration File) 

The `validateRequest` which provides additional protection against [XSS](#SCS0029) is disabled in configuration file.

#### Risk

[XSS](#SCS0029)

#### Vulnerable Code

```xml
<system.web>
   ...
   <pages [..] validateRequest="false" [..]/>
   ...
</system.web>

```

#### Solution

Although it performs blacklisting (that is worse than whitelisting by definition) and you should not rely solely on it for XSS protection, it provides a first line of defense for your application. Do not disable the validation: The default value is `true`. Or set it explicitly:

```xml
<system.web>
   ...
   <pages [..] validateRequest="true" [..]/>
   ...
</system.web>

```

#### References

[CWE-554: ASP.NET Misconfiguration: Not Using Input Validation Framework](https://cwe.mitre.org/data/definitions/554.html)  
[MSDN: pages Element (ASP.NET Settings Schema)](https://msdn.microsoft.com/en-us/library/950xf363%28v=vs.100%29.aspx)  
[MSDN: Request Validation in ASP.NET](https://msdn.microsoft.com/en-us/library/hh882339%28v=vs.110%29.aspx)  
[OWASP: ASP.NET Request Validation](https://www.owasp.org/index.php/ASP.NET%5FRequest%5FValidation)  
See [XSS](#SCS0029) references.

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)