<h2>Why is this an issue?</h2>
<p>Nested code blocks create new scopes where variables declared within are inaccessible from the outside, and their lifespan ends with the block.</p>
<p>Although this may appear beneficial, their usage within a function often suggests that the function is overloaded. Thus, it may violate the Single
Responsibility Principle, and the function needs to be broken down into smaller functions.</p>
<p>The presence of nested blocks that don’t affect the control flow might suggest possible mistakes in the code.</p>
<h3>Exceptions</h3>
<p>The usage of a code block after a <code>case</code> is allowed.</p>
<h2>How to fix it</h2>
<p>The nested code blocks should be extracted into separate methods.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
public void Evaluate()
{
    /* ... */
    {     // Noncompliant - nested code block '{' ... '}'
          int a = stack.pop();
          int b = stack.pop();
          int result = a + b;
          stack.push(result);
    }
    /* ... */
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
public void Evaluate()
{
    /* ... */
    StackAdd();
    /* ... */
}

private void StackAdd()
{
      int a = stack.pop();
      int b = stack.pop();
      int result = a + b;
      stack.push(result);
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Single-responsibility_principle">Single Responsibility Principle</a> </li>
</ul>

