﻿## SA1126

<table>
<tr>
  <td>TypeName</td>
  <td>SA1126PrefixCallsCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1126</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

A call to a member is not prefixed with the 'this.', 'base.', 'object.' or 'typename.' prefix to indicate the intended method call, within a C# code file.

## Rule description

A violation of this rule occurs whenever the code contains a call to a member which is not prefixed correctly.

In some case from sourcecode analysis we cannot be sure which prefix is required. 
                    It could be 'this', 'base', 'object', the typename of the class we're in or one 
                    of our base classes.

## How to fix violations

To fix a violation of this rule, insert the correct prefix before the call to the class member.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1126:PrefixCallsCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1126 // PrefixCallsCorrectly
#pragma warning restore SA1126 // PrefixCallsCorrectly
```
