﻿## SA1402

<table>
<tr>
  <td>TypeName</td>
  <td>SA1402FileMayOnlyContainASingleType</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1402</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

A C# code file contains more than one unique type.

## Rule description

A violation of this rule occurs when a C# file contains more than one type. To increase long-term maintainability of the code-base, each type should be placed in its own file, and file names should reflect the name of the type within the file.

It is possible to configure which kind of types this rule should affect. By default, it allows delegates, enums, structs and interfaces to be placed together with a class.

It is also possible to place multiple parts of the same partial type within the same file.

## How to fix violations

To fix an instance of this violation, move each type into its own file.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1402:FileMayOnlyContainASingleType", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1402 // FileMayOnlyContainASingleType
#pragma warning restore SA1402 // FileMayOnlyContainASingleType
```
