﻿## SA1648

<table>
<tr>
  <td>TypeName</td>
  <td>SA1648InheritDocMustBeUsedWithInheritingClass</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1648</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

`<inheritdoc>` has been used on an element that doesn't inherit from a base class or implement an interface.

## Rule description

Verifies that an `<inheritdoc>` element is not used when the class or interface does not inherit from a base class or
interface. A violation of this rule occurs when the element having the `<inheritdoc>` element doesn't inherit from a
base case or implement an interface.

`<inheritdoc/>` elements are always allowed when they contain a `cref` attribute, which specifies the target element
from which documentation is inherited.

## How to fix violations

To fix a violation of this rule, remove the `<inheritdoc>` element and document the element appropriately.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1648:InheritDocMustBeUsedWithInheritingClass", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1648 // InheritDocMustBeUsedWithInheritingClass
#pragma warning restore SA1648 // InheritDocMustBeUsedWithInheritingClass
```
