<h2>Why is this an issue?</h2>
<p>Duplicated string literals make the process of refactoring complex and error-prone, as any change would need to be propagated on all
occurrences.</p>
<h3>Exceptions</h3>
<p>To prevent generating some false-positives, literals having less than 5 characters are excluded.</p>
<h2>How to fix it</h2>
<p>Use constants to replace the duplicated string literals. Constants can be referenced from many places, but only need to be updated in a single
place.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>With the default threshold of 3:</p>

```java
public void run() {
  prepare("action1");                              // Noncompliant - "action1" is duplicated 3 times
  execute("action1");
  release("action1");
}

@SuppressWarning("all")                            // Compliant - annotations are excluded
private void method1() { /* ... */ }
@SuppressWarning("all")
private void method2() { /* ... */ }

public String printInQuotes(String a, String b) {
  return "'" + a + "'" + b + "'";               // Compliant - literal "'" has less than 5 characters and is excluded
}
```
<h4>Compliant solution</h4>

```java
private static final String ACTION_1 = "action1";  // Compliant

public void run() {
  prepare(ACTION_1);                               // Compliant
  execute(ACTION_1);
  release(ACTION_1);
}
```