<h2>Why is this an issue?</h2>
<p>Catching <code>Exception</code> seems like an efficient way to handle multiple possible exceptions. Unfortunately, it traps all exception types,
both checked and runtime exceptions, thereby casting too broad a net. Indeed, was it really the intention of developers to also catch runtime
exceptions? To prevent any misunderstanding, if both checked and runtime exceptions are really expected to be caught, they should be explicitly listed
in the <code>catch</code> clause.</p>
<p>This rule raises an issue if <code>Exception</code> is caught when it is not explicitly thrown by a method in the <code>try</code> block.</p>
<h3>Noncompliant code example</h3>

```java
try {
  // do something that might throw an UnsupportedDataTypeException or UnsupportedEncodingException
} catch (Exception e) { // Noncompliant
  // log exception ...
}
```
<h3>Compliant solution</h3>

```java
try {
  // do something
} catch (UnsupportedEncodingException|UnsupportedDataTypeException|RuntimeException e) {
  // log exception ...
}
```
<p>or if runtime exceptions should not be caught:</p>

```java
try {
  // do something
} catch (UnsupportedEncodingException|UnsupportedDataTypeException e) {
  // log exception ...
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/396">CWE-396 - Declaration of Catch for Generic Exception</a> </li>
</ul>