<h2>Why is this an issue?</h2>
<p>Specifying the default value for an annotation parameter is redundant. Such values should be omitted in the interests of readability.</p>
<h3>Noncompliant code example</h3>

```java
@MyAnnotation(arg = "def")  // Noncompliant
public class MyClass {
  // ...
}
public @interface MyAnnotation {
  String arg() default "def";
}
```
<h3>Compliant solution</h3>

```java
@MyAnnotation
public class MyClass {
  // ...
}
public @interface MyAnnotation {
  String arg() default "def";
}
```