<h2>Why is this an issue?</h2>
<p>An <code>assert</code> is inappropriate for parameter validation because assertions can be disabled at runtime in the JVM, meaning that a bad
operational setting would completely eliminate the intended checks. Further, <code>assert</code>s that fail throw <code>AssertionError</code>s, rather
than throwing some type of <code>Exception</code>. Throwing <code>Error</code>s is completely outside of the normal realm of expected
<code>catch</code>/<code>throw</code> behavior in normal programs.</p>
<p>This rule raises an issue when a <code>public</code> method uses one or more of its parameters with <code>assert</code>s.</p>
<h3>Noncompliant code example</h3>

```java
 public void setPrice(int price) {
  assert price >= 0 && price <= MAX_PRICE;
  // Set the price
 }
```
<h3>Compliant solution</h3>

```java
 public void setPrice(int price) {
  if (price < 0 || price > MAX_PRICE) {
    throw new IllegalArgumentException("Invalid price: " + price);
  }
  // Set the price
 }
```
<h2>Resources</h2>
<p><a href="https://docs.oracle.com/javase/7/docs/technotes/guides/language/assert.html">Programming With Assertions</a></p>