<h2>Why is this an issue?</h2>
<p>Testing equality of an enum value with <code>equals</code> is perfectly valid because an enum is an Object and every Java developer knows "=="
should not be used to compare the content of an Object. At the same time, using "==" on enums:</p>
<ul>
  <li> provides the same expected comparison (content) as <code>equals</code> </li>
  <li> is more null-safe than equals() </li>
  <li> provides compile-time (static) checking rather than runtime checking </li>
</ul>
<p>For these reasons, use of "==" should be preferred to <code>equals</code>.</p>
<h3>Noncompliant code example</h3>

```java
public enum Fruit {
   APPLE, BANANA, GRAPE
}

public enum Cake {
  LEMON_TART, CHEESE_CAKE
}

public boolean isFruitGrape(Fruit candidateFruit) {
  return candidateFruit.equals(Fruit.GRAPE); // Noncompliant; this will raise an NPE if candidateFruit is NULL
}

public boolean isFruitGrape(Cake candidateFruit) {
  return candidateFruit.equals(Fruit.GRAPE); // Noncompliant; always returns false
}
```
<h3>Compliant solution</h3>

```java
public boolean isFruitGrape(Fruit candidateFruit) {
  return candidateFruit == Fruit.GRAPE; // Compliant; there is only one instance of Fruit.GRAPE - if candidateFruit is a GRAPE it will have the same reference as Fruit.GRAPE
}

public boolean isFruitGrape(Cake candidateFruit) {
  return candidateFruit == Fruit.GRAPE; // Compliant; compilation time failure
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://www.infoworld.com/article/2074292/use-----or-----to-compare-java-enums.html">Use == (or !=) to Compare Java Enums</a> </li>
</ul>