<h2>Why is this an issue?</h2>
<p>When a type variable or a wildcard declares an upper bound that is <code>final</code>, the parametrization is not generic at all because it accepts
one and only one type at runtime: the one that is <code>final</code>. Instead of using <code>Generics</code>, it’s simpler to directly use the
concrete <code>final</code> class.</p>
<h3>Noncompliant code example</h3>

```java
public static <T extends String> T getMyString() { // Noncompliant; String is a "final" class and so can't be extended
 [...]
}
```
<h3>Compliant solution</h3>

```java
public static String getMyString() { // Compliant
  [...]
}
```