<h2>Why is this an issue?</h2>
<p>Multiple spaces in a regular expression can make it hard to tell how many spaces should be matched. It’s more readable to use only one space and
then indicate with a quantifier how many spaces are expected.</p>
<h3>Noncompliant code example</h3>

```java
Pattern.compile("hello   world");
```
<h3>Compliant solution</h3>

```java
Pattern.compile("hello {3}world");
```
<h3>Exceptions</h3>
<p>In <a href="https://www.regular-expressions.info/freespacing.html">free-spacing mode</a> (<code>Pattern.COMMENTS</code> flag, or with embedded flag
expression <code>(?x)</code>), whitespaces are ignored. In this case no issue should be triggered, because the whitespaces may be intended to improve
readability.</p>