<h2>Why is this an issue?</h2>
<p>Ternary operator should not be used to select between two boolean values, or instead of a logical <code>OR</code> operation. Ternary expressions
are often difficult to read, so if a simpler syntax exists, it should be used instead of a ternary expression. This happens when</p>
<ul>
  <li> the expression returns two boolean values </li>
</ul>

```js
let isGood = value > 0 ? true : false; // Non-compliant, replace with value > 0
let isBad = value > 0 ? false : true; // Non-compliant, replace with !(value > 0)
```
<ul>
  <li> the same value is used for both the conditional test and the consequent </li>
</ul>

```js
let a = x ? x : y;  // Non-compliant, replace with x || y
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Conditional_operator">Ternary operator</a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_NOT">Logical NOT (!)</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_OR">Logical OR (||)</a> </li>
</ul>