<h2>Why is this an issue?</h2>
<p>Disabling unit tests lead to a lack of visibility into why tests are ignored, a decline in code quality as underlying problems remain unaddressed,
and an increased maintenance burden due to the accumulation of disabled tests. It can also create a false sense of security about the stability of the
codebase and pose challenges for new developers who may lack the context to understand why tests were disabled. Proper documentation and clear reasons
for disabling tests are essential to ensure they are revisited and re-enabled once the issues are resolved.</p>
<p>This rule raises an issue when a test construct from Jasmine, Jest, Mocha, or Node.js Test Runner is disabled without providing an explanation. It
relies on the presence of a package.json file and looks at the dependencies to determine which testing framework is used.</p>
<h2>How to fix it in Jasmine</h2>
<p>A comment should be added before, on, or after the line of the unit test explaining why the test was disabled. Alternatively, if the test is no
longer relevant, it should be removed entirely.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
describe('foo', function() {
  xit('should do something', function(done) { // Noncompliant
    done();
  });
});
```
<h4>Compliant solution</h4>

```ts
describe('foo', function() {
  // Reason: There is a bug in the code
  xit('should do something', function(done) { // Compliant
    done();
  });
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Jasmine Documentation - <a href="https://jasmine.github.io/api/3.0/global.html#xit">xit</a> </li>
  <li> Jest Documentation - <a href="https://jestjs.io/docs/api#testskipname-fn">test.skip</a> </li>
  <li> Mocha Documentation - <a href="https://mochajs.org/#inclusive-tests">Inclusive tests</a> </li>
  <li> Node.js Documentation - <a href="https://nodejs.org/docs/latest/api/test.html#skipping-tests">Skipping tests</a> </li>
</ul>