<h2>Why is this an issue?</h2>
<p>TypeScript provides the <code>type</code> mechanism to create a type alias, that is, a new name to refer to an existing type. It is a nice feature
to improve code readability and can be used as documentation. However, aliasing a primitive type, another alias or everyday types like
<code>any</code> or <code>unknown</code> is useless and goes against the idea of readable code. As a result, a reader needs to go through the mental
exercise of remembering the underlying type behind the alias and loses track of the code’s primary purpose.</p>
<p>Common types come with relevant names and should be used as they are.</p>
<h2>How to fix it</h2>
<p>The type alias should be removed, and all the occurrences of the alias should be replaced with the type it referred to.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
type MyString  = string;
type MyBoolean = boolean;

function isPalindrom(s: MyString): MyBoolean {
    return s === s.split('').reverse().join('');
}
```
<h4>Compliant solution</h4>

```ts
function isPalindrom(s: string): boolean {
    return s === s.split('').reverse().join('');
}
```