import{_ as t,h as a,ak as o,g as r}from"./chunks/framework.BpCjdwm5.js";const i="/assets/feedbackloops.CmgUXvXq.png",g=JSON.parse('{"title":"Getting Started","description":"","frontmatter":{"title":"Getting Started"},"headers":[],"relativePath":"getting-started/index.md","filePath":"getting-started/index.md"}'),n={name:"getting-started/index.md"};function s(l,e,c,u,h,d){return r(),a("div",null,e[0]||(e[0]=[o('<h1 id="getting-started" tabindex="-1">Getting Started <a class="header-anchor" href="#getting-started" aria-label="Permalink to &quot;Getting Started&quot;">​</a></h1><p>We are happy that you want to give Teamscale a try! On this page, you can find guides helping you to get started with Teamscale and its analyses. If you don&#39;t know yet which analysis is relevant for you, you can find some guidance on our <a href="https://teamscale.com/product-overview" target="_blank" rel="noreferrer">website</a>.</p><p>Once you are ready to get some hands-on experience, you can start with <a href="#installing-teamscale-and-setting-up-your-first-project">Installing Teamscale and Setting Up Your First Project</a> which you&#39;ll need for all analyses.</p><p>Feel free to contact <a href="mailto:evaluation@teamscale.com" target="_blank" rel="noreferrer">evaluation@teamscale.com</a> at any time with questions or problems!</p><div class="tip custom-block"><p class="custom-block-title">Organizational Best Practices for a Quick and Successful Start</p><p>Our experiences show that new tools should always be introduced <strong>step by step</strong>. Many of our customers started with a single system and expanded afterwards. Good rules of thumb for a successful evaluation are:</p><ul><li>Start with a small, controlled system or even parts of a system.</li><li>Do not start with the most difficult technology.</li><li>Choose a system whose team is eager to try new approaches.</li><li>Strive for a quick proof of concept.</li></ul></div><h2 id="installing-teamscale-and-setting-up-your-first-project" tabindex="-1">Installing Teamscale and Setting Up Your First Project <a class="header-anchor" href="#installing-teamscale-and-setting-up-your-first-project" aria-label="Permalink to &quot;Installing Teamscale and Setting Up Your First Project&quot;">​</a></h2><p>To try out Teamscale, the first step is of course to set up a Teamscale server. You can <a href="./../howto/installing-teamscale/">host Teamscale on-premise</a>, or you can use the <a href="https://teamscale.com/cloud" target="_blank" rel="noreferrer">Teamscale cloud</a>. Every Teamscale license includes cloud hosting for free, so you can concentrate on your code instead of running the tools.</p><p>Once you have your instance, <a href="./../howto/creating-a-project/">create your first project</a>. For an overview how to navigate Teamscale, have a look at the <a href="./../reference/ui/general-ui-features/">general UI features</a>. Now that you know the basics, skip to the section for the analysis you are interested in below.</p><h2 id="improving-code-quality-with-static-code-analysis" tabindex="-1">Improving Code Quality with Static Code Analysis <a class="header-anchor" href="#improving-code-quality-with-static-code-analysis" aria-label="Permalink to &quot;Improving Code Quality with Static Code Analysis&quot;">​</a></h2><p>Static code analysis (SCA) in Teamscale is the most straight forward analysis to set up. You&#39;ve already done all the basics by setting up an analysis profile and a project. The checks you defined in your analysis profile ran during the initial analysis phase and the results are already available in Teamscale&#39;s web UI. For example, you will see them mainly in the <a href="./../reference/ui/activity/commits/">Activity</a>, <a href="./../reference/ui/findings/">Findings</a> and <a href="./../reference/ui/metrics/">Metrics</a> perspectives (continue reading here before diving deeper into the individual perspectives).</p><p>In this section, we&#39;ll show how you can integrate the results of Teamscale&#39;s SCA in the tools and processes you are already using in order to use the results effectively, especially since Teamscale works differently compared to other tools on the market. Teamscale does not analyze the whole codebase in batch (c.f. <a href="./../introduction/why-many-fail-to-improve/">How (Not) To Control Quality</a>) but <strong>every single commit incrementally</strong>. This enables faster and more personalized feedback, as you can see which problems were newly introduced on a commit level (c.f. <a href="./../introduction/improving-software-quality/#why-fast-feedback-is-essential">Why Fast Feedback is Essential</a>).</p><p>At this point, we propose three feedback loops to integrate the analysis results in your development processes and tools: <img src="'+i+'" alt="feedbackloops.png" width="4146" height="1884" data-zoom="true"></p><ol><li><p><strong>Developer feedback</strong>: The incremental analysis of Teamscale creates results for each new code commit. You can see them in the Teamscale web UI (e.g. in the <a href="./../reference/ui/activity/commits/">Activity</a> or <a href="./../reference/ui/findings/">Findings</a> perspectives) within <strong>seconds</strong> after pushing the code changes. In addition, you can use Teamscale&#39;s <a href="./../tutorial/getting-personalized-feedback/#stay-informed-without-leaving-your-ide-or-editor">IDE integration</a>, so that developers see problems <a href="./../glossary/#pre-commit-analysis">even before committing their changes</a> directly in their IDE.</p></li><li><p><strong>Reviewer feedback</strong>: Teamscale can also integrate in your existing review tools and workflows to provide additional support in doing professional and tool-supported reviews. For example, you can also integrate the analyses&#39; results into your</p><ul><li><a href="./../tutorial/getting-personalized-feedback/#get-feedback-in-pull-and-merge-requests">your pull/merge requests</a> and</li><li><a href="./../tutorial/getting-personalized-feedback/#analyze-code-and-test-quality-in-jira">your Jira Issues</a>, so that the review can keep an eye on the newly introduced findings for a feature or bug fix before merging the changes back to the main branch.</li></ul></li><li><p><strong>Development Team Feedback</strong>: Teamscale also provides features for analysing quality trends for configurable time periods in order to support development teams in tracking their code quality over time. For example, you can create <a href="./../tutorial/getting-quality-overview/">quality dashboards</a> for your projects to <a href="./../tutorial/monitoring-quality-evolution/">monitor and assess quality evolution</a>. In order to establish a continuous quality control process, you can also <a href="./../tutorial/creating-quality-report/">create quality reports</a> to store artifacts to discuss, e.g. in the scope of a recurring team (quality) retrospective.</p></li></ol><p>Go ahead and set up the integrations you are interested in right away.</p><p>Once finished, you may want to learn</p><ul><li><a href="./../introduction/best-practices/">about our best practices on how to use SCA</a> to achieve lasting improvements in code quality over time.</li><li><a href="./../introduction/improving-software-quality/">about improving software quality with Teamscale</a> in general to get an overview</li><li><a href="./../reference/ui/architecture/">about Architecture Analysis</a></li><li><a href="./../reference/supported-technologies/">about supported technologies</a></li><li><a href="./../reference/ui/qualitycontrol/tasks/">about Tasks in Teamscale</a></li></ul><h2 id="improving-test-quality-with-test-gap-analysis" tabindex="-1">Improving Test Quality with Test Gap Analysis <a class="header-anchor" href="#improving-test-quality-with-test-gap-analysis" aria-label="Permalink to &quot;Improving Test Quality with Test Gap Analysis&quot;">​</a></h2><p>If you don&#39;t yet know what Test Gap Analysis (TGA) is, read how you can use it to <a href="./../introduction/improving-test-quality/">improve test quality</a> or watch our workshop in <a href="https://youtu.be/Dp1WmWdkcLM?si=ty_iTSfTGtmYay7x" target="_blank" rel="noreferrer">English</a> or <a href="https://youtu.be/l2BuyiYQAc4?si=vheq8_617Lfnwm17" target="_blank" rel="noreferrer">German</a>.</p><p>TGA needs the code changes from your version control system and test coverage from your test environments to determine which changed code has not been tested yet.</p><p>To get the changes, the only thing Teamscale needs is a connection to your repository. You&#39;ve already done that when you set up <a href="./#installing-teamscale-and-setting-up-your-first-project">your first project</a>.</p><p>For the test coverage, you can <a href="./../howto/uploading-external-data/#upload-via-command-line">upload your existing test coverage</a> if you are already collecting it for your tests. Alternatively, you can learn <a href="./../howto/setting-up-profiler-tga/">how to collect coverage for your programming language</a> and even <a href="./../howto/setting-up-profiler-tga/manual-tests/">for manual tests</a>. If you want to follow a step-by-step guide with an example project, you can use our tutorials for <a href="./../tutorial/setting-up-tga-java/">Java</a> and <a href="./../tutorial/setting-up-tga-dotnet/">C#</a></p><p>Once you set up both the connection to the version control system and the upload of the test coverage you can learn <a href="./../tutorial/working-with-test-gap-treemaps/">how to interpret the results of TGA efficiently</a> and <a href="./../howto/creating-a-tga-dashboard/">how to create a TGA dashboard</a>. You can also learn <a href="./../tutorial/analyzing-issue-test-gaps/">how to analyze Test Gaps aggregated by issues</a>.</p><p>To get feedback on your tests in the tools you are already using, learn how to integrate the results of Test Gap Analysis <a href="./../tutorial/getting-personalized-feedback/#analyze-code-and-test-quality-in-jira">in your Jira tickets</a>.</p><h2 id="dealing-with-long-running-test-suites-with-test-impact-and-pareto-analysis" tabindex="-1">Dealing with Long Running Test Suites with Test Impact and Pareto Analysis <a class="header-anchor" href="#dealing-with-long-running-test-suites-with-test-impact-and-pareto-analysis" aria-label="Permalink to &quot;Dealing with Long Running Test Suites with Test Impact and Pareto Analysis&quot;">​</a></h2><p>If you don&#39;t yet know what Test Impact Analysis (TIA) or Pareto Analysis is, read how you can use them to <a href="./../tutorial/improving-test-efficiency/">get fast feedback despite long-running test suites</a> or watch our workshop in <a href="https://youtu.be/Sg-PKzCZgBg?si=wQJ_b3dMBrFQYQFr" target="_blank" rel="noreferrer">English</a> or <a href="https://youtu.be/Mzs06pV35uI?si=54X4y6NffZE-y5Rf" target="_blank" rel="noreferrer">German</a>.</p><p>To set up TIA and Pareto, you first need to record for each test, which areas of the code it covers. That&#39;s what we call &quot;testwise coverage&quot;. Learn <a href="./../howto/providing-testwise-coverage/">how to record testwise coverage for any programming language</a>.</p><p>Teamscale uses the information from testwise coverage combined with the changes it reads from the version control system to determine which tests are impacted, meaning which tests run through the changed areas and therefore need to be executed in the next test run. We provide <a href="./../howto/providing-testwise-coverage/#java-virtual-machine-jvm">plugins for Maven and Gradle</a> combined with JUnit 5. If you use a different test runner, please <a href="mailto:evaluation@teamscale.com" target="_blank" rel="noreferrer">reach out</a> or, if you are building your own, refer to our API under <code>&lt;your-teamscale-url&gt;/api/public</code> (section <code>Test Intelligence</code>) to implement the integration yourself.</p><p>Learn <a href="./../tutorial/improving-test-efficiency/">how to use TIA and Pareto</a> in our tutorial.</p><h2 id="connecting-requirements-with-code-and-tests-using-requirements-tracing" tabindex="-1">Connecting Requirements with Code and Tests using Requirements Tracing <a class="header-anchor" href="#connecting-requirements-with-code-and-tests-using-requirements-tracing" aria-label="Permalink to &quot;Connecting Requirements with Code and Tests using Requirements Tracing&quot;">​</a></h2><p>Learn <a href="./../introduction/agile-requirements-tracing/">how to use Requirements Tracing to connect the requirements to their implementation and tests</a> in order to figure out, for example, whether your requirements are verified correctly by your tests.</p><p>Learn how to set it up in our <a href="./../tutorial/setting-up-requirements-tracing/">tutorial</a>.</p>',31)]))}const f=t(n,[["render",s]]);export{g as __pageData,f as default};
