import{_ as a,h as t,ak as o,g as s}from"./chunks/framework.BpCjdwm5.js";const i="/assets/automatic-backup.BfSSMkdJ.png",m=JSON.parse('{"title":"Handling Backups","description":"","frontmatter":{"title":"Handling Backups"},"headers":[],"relativePath":"howto/handling-backups/index.md","filePath":"howto/handling-backups/index.md"}'),r={name:"howto/handling-backups/index.md"};function n(c,e,p,l,h,u){return s(),t("div",null,e[0]||(e[0]=[o('<h1 id="how-to-handle-backups-import-export-automatic-backups" tabindex="-1">How to Handle Backups (Import, Export, Automatic Backups) <a class="header-anchor" href="#how-to-handle-backups-import-export-automatic-backups" aria-label="Permalink to &quot;How to Handle Backups (Import, Export, Automatic Backups)&quot;">​</a></h1><p>Backups in Teamscale are very helpful when upgrading to a new Teamscale version or to mitigate the risk of potential data loss.</p><div class="tip custom-block"><p class="custom-block-title">Automatic Backups</p><p>We highly recommend automatic backups to be enabled for all production use of Teamscale. See the respective section below on how to configure automatic backups.</p></div><nav class="table-of-contents"><ul><li><a href="#exporting-backups">Exporting Backups</a></li><li><a href="#importing-backups">Importing backups</a></li><li><a href="#automated-backups">Automated backups</a></li><li><a href="#backup-to-from-amazon-aws-s3">Backup to/from Amazon AWS S3</a><ul><li><a href="#s3-urls">S3 URLs</a></li><li><a href="#s3-http-s-urls">S3+HTTP(S) URLS</a></li></ul></li><li><a href="#storage-snapshot-backups">Storage snapshot backups</a><ul><li><a href="#configuring-automatic-snapshots">Configuring Automatic Snapshots</a></li><li><a href="#recovering-using-a-storage-snapshot">Recovering using a Storage Snapshot</a></li></ul></li></ul></nav><h2 id="exporting-backups" tabindex="-1">Exporting Backups <a class="header-anchor" href="#exporting-backups" aria-label="Permalink to &quot;Exporting Backups&quot;">​</a></h2><p>Depending on your needs (e.g., during an update), you can export only <em>global data</em> (like users, groups, settings, permissions, dashboards), <em>project data</em> (e.g., tolerations, false positives, baselines and external findings), or both. Furthermore, you can choose to only export project data for some rather than all of your projects.</p><p>To create a backup, first navigate to <em>Admin</em> &gt; <em>Backup</em>. Here you have two options to initiate the backup:</p><p>When you choose <em>Export Backup</em>, your browser will download a single backup ZIP and you can store it locally.</p><p>Alternatively, you can provide a file-system path (or <a href="#backup-to-from-amazon-aws-s3">S3 URI</a>) to let Teamscale store your backup there. This way is often preferable if the backup ZIP would be too large to comfortably download.</p><div class="warning custom-block"><p class="custom-block-title">Rescue backup on startup</p><p>Under certain error conditions (e.g. database corruption) the above mechanism may not work anymore for exporting backups. In this case the command line argument <code>-b &lt;PATH-TO-BACKUP-FILE&gt;</code> passed to the teamscale.sh or .bat file can be used to dump a rescue backup during the startup of Teamscale.</p></div><h2 id="importing-backups" tabindex="-1">Importing backups <a class="header-anchor" href="#importing-backups" aria-label="Permalink to &quot;Importing backups&quot;">​</a></h2><p>You have three options to import a backup:</p><p>The first option is the tab <em>Upload Backup File</em>. Your browser will then let you select a single backup ZIP which you have downloaded previously. Clicking on the <em>Upload Backup</em> button will initiate the import.</p><p>The second option is the tab <em>Load Backup from other instance</em>. In this case you have to provide the URL and the credentials of another Teamscale instance. The URL of this other instance has to be reachable from your current one. After clicking on the <em>Import Backup</em> button, the remote Teamscale instance will export a backup which then will be imported on your current instance.</p><p>The third option is to provide a file-system path (or <a href="#backup-to-from-amazon-aws-s3">S3 URI</a>) to a previously exported backup on the tab <em>Read Backup From File or URL</em>. Then, choose <em>Import Backup</em> to let Teamscale fetch the backup and import it.</p><h2 id="automated-backups" tabindex="-1">Automated backups <a class="header-anchor" href="#automated-backups" aria-label="Permalink to &quot;Automated backups&quot;">​</a></h2><p>For all production uses we highly recommend configuring automated backups. Once configured, Teamscale will regularly perform an automated backup export. This ensures that you can always resort to an up-to-date backup in case of data loss.</p><div class="tip custom-block"><p class="custom-block-title">Default Automatic Backup Settings</p><p>Automatic backups are enabled automatically on the first start of Teamscale using default settings for the backup storage location and for how many backup files will be kept. We recommend revisiting the default settings of automatic backups to make sure that they are in line with your preferences.</p></div><p>To configure automated backups, open the <em>Admin</em> perspective and navigate to <em>Settings</em> &gt; <em>Automatic Backup</em>. <img src="'+i+'" alt="Automatic Backup Settings" width="947" height="591" data-zoom="true"> Here you can configure the file name pattern of the backup to be created. Several placeholders can be used to better identify a backup file as described in the description of the settings page. It is recommended to use the <code>%t</code> placeholder in the file name for reflecting the creation time in the file name.</p><p>The &quot;Backup schedule&quot; setting allows to define the frequency of the automatic backups. This setting also defines whether the automatic backup is enabled at all (leave empty to disable). We highly recommend a nightly schedule. To ensure that the backups created to not exceed the disk space available, options exist on how many backups should be preserved for a given interval. For example, you can configure Teamscale to keep daily backups for the last 7 days, weekly backups for the last 5 weeks and monthly backups for 3 months. Teamscale will regularly delete all other backups to free up disk space.</p><h2 id="backup-to-from-amazon-aws-s3" tabindex="-1">Backup to/from Amazon AWS S3 <a class="header-anchor" href="#backup-to-from-amazon-aws-s3" aria-label="Permalink to &quot;Backup to/from Amazon AWS S3&quot;">​</a></h2><p>All aforementioned backup options (including automated backup) also work to/from AWS S3 buckets (or with S3-compatible storage solutions). Instead of specifying a file-system path, you simply specify an S3 URI, e.g., <code>s3://bucket/key</code> or <code>s3+https://acesskey:secretkey@s3.example.com/bucket/path</code> . Rotation settings of automatic backups are also applied to backups stored in S3.</p><p>You have two options to specify the path to an S3 bucket: <code>s3</code> &amp; <code>s3+http(s)</code> URLS.</p><h3 id="s3-urls" tabindex="-1">S3 URLs <a class="header-anchor" href="#s3-urls" aria-label="Permalink to &quot;S3 URLs&quot;">​</a></h3><p>Here, the format of the URI is as follows:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>s3://&lt;bucket&gt;/&lt;path&gt;</span></span></code></pre></div><p>To use this <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro.html" target="_blank" rel="noreferrer">URL format</a>, you must set up the machine&#39;s AWS environment outside of Teamscale. At a bare minimum, you need to define the access key ID, the access key and the bucket region. If auto-detection of the region used by the AWS client fails, you can override it by setting the system property <code>com.teamscale.aws.region</code>.</p><h3 id="s3-http-s-urls" tabindex="-1">S3+HTTP(S) URLS <a class="header-anchor" href="#s3-http-s-urls" aria-label="Permalink to &quot;S3+HTTP(S) URLS&quot;">​</a></h3><p>In this case, the format of the URI is as follows:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>(s3+http|s3+https)://[&lt;access key&gt;:&lt;secret key&gt;@]&lt;hostname&gt;[:&lt;port&gt;]/&lt;bucket&gt;/&lt;path&gt;</span></span></code></pre></div><p>The S3 bucket must be specified as part of the URI&#39;s path, not the hostname. In other words, you have to use <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro#path-style-url-ex" target="_blank" rel="noreferrer">path-style access</a> rather than <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro#virtual-host-style-url-ex" target="_blank" rel="noreferrer">virtual-host-style access</a>.</p><p>If either access key or secret key contain a slash (<code>/</code>), it must be percent-escaped as <code>%2F</code>.</p><p>Instead of providing your access and secret key directly in the URI, it is also possible to store them under <em>Admin</em> &gt; <em>External Credentials</em>. To do so, create an external credential entry whose ID and URL both match your chosen hostname and port: <code>http(s)://&lt;hostname&gt;[:&lt;port&gt;]</code>. The entry&#39;s <em>Username</em> and <em>Password</em> then are your S3 access key and secret key, respectively.</p><h2 id="storage-snapshot-backups" tabindex="-1">Storage snapshot backups <a class="header-anchor" href="#storage-snapshot-backups" aria-label="Permalink to &quot;Storage snapshot backups&quot;">​</a></h2><p>Teamscale can be configured to automatically create snapshots of its database.</p><h3 id="configuring-automatic-snapshots" tabindex="-1">Configuring Automatic Snapshots <a class="header-anchor" href="#configuring-automatic-snapshots" aria-label="Permalink to &quot;Configuring Automatic Snapshots&quot;">​</a></h3><p>The backups created by Teamscale contain all user generated data (e.g. configurations, architectures, dashboards, and tolerated findings), and uploads (such as coverage data). These backups are useful when migrating to a new version or recovering data that was mistakenly deleted. However, restarting an instance from such a backup requires a reanalysis, which can take some time and might be unsuitable for crash recovery, when fast recovery time is more important.</p><p>This gap is filled by storage snapshot backups, which store a snapshot of the entire storage system in one backup file, which has a size that is almost as big as the storage directory. These storage snapshot backups can be created manually in the <em>Backup</em> view of the <em>Admin</em> perspective. It is recommended to configure a regular schedule for creating storage snapshots in the <em>Settings</em> &gt; <em>Automatic Backup</em> view, in the <em>Automatic Storage System Snapshots</em> section. The backup location supports the same placeholders and URI schemes as the normal backup, so storing snapshots in S3 is possible.</p><div class="warning custom-block"><p class="custom-block-title">Snapshot Support</p><p>Note that storage snapshot backups are only supported by these database types: RocksDB, In-Memory (see also <a href="./../../reference/administration-ts-installation/#primary-settings-–-teamscale-properties">Configuring Teamscale</a> on how to configure the database type).</p></div><h3 id="recovering-using-a-storage-snapshot" tabindex="-1">Recovering using a Storage Snapshot <a class="header-anchor" href="#recovering-using-a-storage-snapshot" aria-label="Permalink to &quot;Recovering using a Storage Snapshot&quot;">​</a></h3><p>To recover from a crash and start a Teamscale instance from the storage snapshot, you have to start the instance with a specific property. For this, add the following parameter to the <code>jvm.properties</code> config file.</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dcom.teamscale.snapshot-backup.load-location</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=LOCATION</span></span></code></pre></div><p>Please note that the import will only be performed, if the storage system is completely empty, to prevent you from accidentally destroying a live instance. In this case, a warning will be logged and the existing instance will be started without any import. Additionally, the version of Teamscale must be the same as the version that was used to create the snapshot. You can not use snapshots during a migration to a newer version of Teamscale.</p><p>When working with storage snapshot backups, please consider these general guidelines:</p><ul><li><p>Backups should be stored on a separate machine (or even data center) to prevent data loss in case of disk failures or environmental hazards.</p></li><li><p>The restore procedure should be tested regularly, both to ensure that all data is available and the steps are known and also to get an idea of how long the restore procedure takes.</p></li><li><p>Also think about backup procedures for the operating system and hardware for a fallback machine, as in case of a hardware failure, you will also need a new machine to start from.</p></li><li><p>Think about procedures to switch URLs to a new machine in case of hardware failures, such as load balancers or suitable DNS update strategies.</p></li></ul>',45)]))}const b=a(r,[["render",n]]);export{m as __pageData,b as default};
