import{_ as h,h as r,ak as o,O as i,z as a,j as e,x as l,L as d,g as c}from"./chunks/framework.BpCjdwm5.js";const f=JSON.parse('{"title":"Teamscale CLI for Developers (teamscale-dev)","description":"","frontmatter":{"title":"Teamscale CLI for Developers (`teamscale-dev`)"},"headers":[],"relativePath":"reference/cli/teamscale-dev/index.md","filePath":"reference/cli/teamscale-dev/index.md"}'),p={name:"reference/cli/teamscale-dev/index.md"};function m(g,s,k,u,b,v){const t=d("PluginTabsTab"),n=d("PluginTabs");return c(),r("div",null,[s[57]||(s[57]=o('<h1 id="command-line-client-for-developers-teamscale-dev" tabindex="-1">Command-Line Client for Developers (<code>teamscale-dev</code>) <a class="header-anchor" href="#command-line-client-for-developers-teamscale-dev" aria-label="Permalink to &quot;Command-Line Client for Developers (`teamscale-dev`)&quot;">​</a></h1><p>This article describes <code>teamscale-dev</code>, the Teamscale command-line client for developers. Among other things, this client can be used to <a href="./../../../getting-started/other-ides/">integrate Teamscale with IDEs</a> for which no dedicated IDE plug-in exists.</p><nav class="table-of-contents"><ul><li><a href="#installation">Installation</a></li><li><a href="#commands">Commands</a><ul><li><a href="#the-pre-commit-command">The pre-commit Command</a></li><li><a href="#the-fetch-findings-command">The fetch-findings Command</a></li><li><a href="#the-open-in-browser-command">The open-in-browser Command</a></li><li><a href="#the-generate-completion-command">The generate-completion Command</a></li></ul></li><li><a href="#common-options">Common Options</a><ul><li><a href="#supplying-server-credentials">Supplying Server Credentials</a></li><li><a href="#disabling-tls-certificate-validation">Disabling TLS Certificate Validation</a></li><li><a href="#overriding-branch-information">Overriding Branch Information</a></li><li><a href="#finding-output-format">Finding Output Format</a></li><li><a href="#logging-debug-trace">Logging (--debug, --trace)</a></li></ul></li><li><a href="#license">License</a></li></ul></nav><h2 id="installation" tabindex="-1">Installation <a class="header-anchor" href="#installation" aria-label="Permalink to &quot;Installation&quot;">​</a></h2><p>The CQSE website offers both platform-specific (for Windows, Linux, macOS) and platform-independent <a href="./../../../getting-started/other-ides/#installing-teamscale-dev">downloads for installation</a>.</p><h2 id="commands" tabindex="-1">Commands <a class="header-anchor" href="#commands" aria-label="Permalink to &quot;Commands&quot;">​</a></h2><p>The command-line client for developers exposes its functionality as a set of commands. You can use the built-in help option, <code>--help</code>, to list all available commands.</p>',7)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[0]||(s[0]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --help")])])])],-1)])),_:1,__:[0]}),i(t,{label:"Windows"},{default:a(()=>s[1]||(s[1]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe --help")])])])],-1)])),_:1,__:[1]}),i(t,{label:"macOS"},{default:a(()=>s[2]||(s[2]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --help")])])])],-1)])),_:1,__:[2]})]),_:1}),s[58]||(s[58]=o('<p>The various commands can be further configured by command-line options. Many options are <a href="#common-options">common</a> to most if not all commands, while others are specific to a command and explained in the following alongside their respective command. Additional configuration is taken from <a href="./../../teamscale-toml/"><code>.teamscale.toml</code> IDE configuration files</a>.</p><h3 id="the-pre-commit-command" tabindex="-1">The <code>pre-commit</code> Command <a class="header-anchor" href="#the-pre-commit-command" aria-label="Permalink to &quot;The `pre-commit` Command&quot;">​</a></h3><p>The <code>pre-commit</code> (or <code>precommit</code>) command uploads files to Teamscale for pre-commit analysis and, once the analysis is finished, displays findings for them in a <a href="#finding-output-format">common format</a>.</p><p>You can use this command in three ways:</p>',4)),e("ol",null,[e("li",null,[s[6]||(s[6]=e("p",null,[e("strong",null,"Automatic Selection of Files for Analysis (default):")],-1)),s[7]||(s[7]=e("p",null,[l("By default, the "),e("code",null,"pre-commit"),l(" command will automatically determine whether the given paths are under version control ("),e("a",{href:"https://git-scm.com/",target:"_blank",rel:"noreferrer"},"Git"),l(" and "),e("a",{href:"https://subversion.apache.org/",target:"_blank",rel:"noreferrer"},"Subversion"),l(" supported). If so, only those files that have uncommitted changes will be uploaded. If not, all files and directories (including subdirectories) are uploaded to the Teamscale server.")],-1)),s[8]||(s[8]=e("div",{class:"info custom-block"},[e("p",{class:"custom-block-title"},"Mixture of Versioned and Unversioned Paths"),e("p",null,"If only some paths are under version control, a warning is displayed, as this may not be what the user intended: Version-controlled files are uploaded only if they contain uncommitted changes, whereas unversioned files are uploaded regardless.")],-1)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[3]||(s[3]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Example.java")])])])],-1),e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/")])])])],-1)])),_:1,__:[3]}),i(t,{label:"Windows"},{default:a(()=>s[4]||(s[4]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit src\\Example.java")])])])],-1),e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit src\\")])])])],-1)])),_:1,__:[4]}),i(t,{label:"macOS"},{default:a(()=>s[5]||(s[5]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Example.java")])])])],-1),e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/")])])])],-1)])),_:1,__:[5]})]),_:1}),s[9]||(s[9]=e("div",{class:"warning custom-block"},[e("p",{class:"custom-block-title"},"Large Uploads"),e("p",null,[l("Uploading a large number of files at once can take a long time and increase the server load. It is hence common (in fact, the default) that a Teamscale server has "),e("a",{href:"./../../admin-settings/#setting-pre-commit-limits"},"pre-commit limits"),l(" configured, limiting the number and size of files included in a single pre-commit upload. Uploads exceeding these limits are rejected.")])],-1))]),e("li",null,[s[13]||(s[13]=e("p",null,[e("strong",null,"Automatic Selection of Uncommitted Changes for Analysis:")],-1)),s[14]||(s[14]=e("p",null,[l("If the given paths are under version control ("),e("a",{href:"https://git-scm.com/",target:"_blank",rel:"noreferrer"},"Git"),l(" and "),e("a",{href:"https://subversion.apache.org/",target:"_blank",rel:"noreferrer"},"Subversion"),l(" supported), and the "),e("code",null,"--only-uncommitted-changes"),l(" option is used, only those files that have uncommitted changes will be uploaded.")],-1)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[10]||(s[10]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --only-uncommitted-changes"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/")])])])],-1)])),_:1,__:[10]}),i(t,{label:"Windows"},{default:a(()=>s[11]||(s[11]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit --only-uncommitted-changes src\\")])])])],-1)])),_:1,__:[11]}),i(t,{label:"macOS"},{default:a(()=>s[12]||(s[12]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --only-uncommitted-changes"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/")])])])],-1)])),_:1,__:[12]})]),_:1}),s[15]||(s[15]=e("p",null,[l("If not all the given paths are under version control, the "),e("code",null,"pre-commit"),l(" command will fail instead of uploading unchanged files. To make your intention explicit and safeguard against such accidental uploads, we hence "),e("strong",null,"recommend"),l(" to always use this option if you believe that the paths in question are under version control.")],-1))]),e("li",null,[s[19]||(s[19]=e("p",null,[e("strong",null,"Explicit Selection of Files for Analysis:")],-1)),s[20]||(s[20]=e("p",null,[l("If the "),e("code",null,"--no-change-detection"),l(" option is used, all given files and directories (including subdirectories) are uploaded to the Teamscale server, even if they are under version control and, according to the version-control system, unchanged.")],-1)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[16]||(s[16]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --no-change-detection"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Example.java")])])])],-1)])),_:1,__:[16]}),i(t,{label:"Windows"},{default:a(()=>s[17]||(s[17]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit --no-change-detection src\\Example.java")])])])],-1)])),_:1,__:[17]}),i(t,{label:"macOS"},{default:a(()=>s[18]||(s[18]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --no-change-detection"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Example.java")])])])],-1)])),_:1,__:[18]})]),_:1}),s[21]||(s[21]=e("div",{class:"warning custom-block"},[e("p",{class:"custom-block-title"},"Large Uploads"),e("p",null,[l("Uploading a large number of files at once can take a long time and increase the server load. It is hence common (in fact, the default) that a Teamscale server has "),e("a",{href:"./../../admin-settings/#setting-pre-commit-limits"},"pre-commit limits"),l(" configured, limiting the number and size of files included in a single pre-commit upload. Uploads exceeding these limits are rejected.")]),e("p",null,[l("Using "),e("code",null,"--no-change-detection"),l(" should hence be restricted to uploading single files.")])],-1))])]),s[59]||(s[59]=o('<p>Further options, e.g., <code>--show-links-to-findings</code> and <code>--findings-to-stderr</code> control how and where the findings are reported.</p><h3 id="the-fetch-findings-command" tabindex="-1">The <code>fetch-findings</code> Command <a class="header-anchor" href="#the-fetch-findings-command" aria-label="Permalink to &quot;The `fetch-findings` Command&quot;">​</a></h3><p>The <code>fetch-findings</code> command fetches findings from Teamscale for one or more paths and displays them in a <a href="#finding-output-format">common format</a>. Unlike the <a href="#the-pre-commit-command"><code>pre-commit</code></a>, <code>fetch-findings</code> does not upload local files to Teamscale; it shows the findings as they exist on the remote server.</p><p>You can use this command in two ways:</p><ol><li><strong>Fetch findings for one or more files:</strong> For example:</li></ol>',5)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[22]||(s[22]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," fetch-findings"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Example.java"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Utils.java")])])])],-1)])),_:1,__:[22]}),i(t,{label:"Windows"},{default:a(()=>s[23]||(s[23]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe fetch-findings src\\Example.java src\\Utils.java")])])])],-1)])),_:1,__:[23]}),i(t,{label:"macOS"},{default:a(()=>s[24]||(s[24]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," fetch-findings"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Example.java"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Utils.java")])])])],-1)])),_:1,__:[24]})]),_:1}),s[60]||(s[60]=e("ol",{start:"2"},[e("li",null,[e("strong",null,"Fetch findings for one or more directories:"),l(" For example:")])],-1)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[25]||(s[25]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," fetch-findings"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/main/java"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/test/java")])])])],-1)])),_:1,__:[25]}),i(t,{label:"Windows"},{default:a(()=>s[26]||(s[26]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe fetch-findings src\\main\\java src\\test\\java")])])])],-1)])),_:1,__:[26]}),i(t,{label:"macOS"},{default:a(()=>s[27]||(s[27]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," fetch-findings"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/main/java"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/test/java")])])])],-1)])),_:1,__:[27]})]),_:1}),s[61]||(s[61]=o('<p>A mixture of files and directories in the same <code>fetch-findings</code> command is not supported at the moment.</p><h3 id="the-open-in-browser-command" tabindex="-1">The <code>open-in-browser</code> Command <a class="header-anchor" href="#the-open-in-browser-command" aria-label="Permalink to &quot;The `open-in-browser` Command&quot;">​</a></h3><p>The <code>open-in-browser</code> (or <code>browse</code>) command opens the <a href="./../../ui/metrics/"><em>Metrics</em></a> &gt; <em>Files</em> view in a Web browser, showing the given files and directories as they are known to Teamscale. For example:</p>',3)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[28]||(s[28]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," open-in-browser"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Example.java")])])])],-1),e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," open-in-browser"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/")])])])],-1)])),_:1,__:[28]}),i(t,{label:"Windows"},{default:a(()=>s[29]||(s[29]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe open-in-browser src\\Example.java")])])])],-1),e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe open-in-browser src\\")])])])],-1)])),_:1,__:[29]}),i(t,{label:"macOS"},{default:a(()=>s[30]||(s[30]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," open-in-browser"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/Example.java")])])])],-1),e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," open-in-browser"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," src/")])])])],-1)])),_:1,__:[30]})]),_:1}),s[62]||(s[62]=o('<p>The Web browser used by <code>teamscale-dev</code> is your desktop&#39;s default browser. Consult your operating system&#39;s documentation for how to change this.</p><h3 id="the-generate-completion-command" tabindex="-1">The <code>generate-completion</code> Command <a class="header-anchor" href="#the-generate-completion-command" aria-label="Permalink to &quot;The `generate-completion` Command&quot;">​</a></h3><p>The <code>generate-completion</code> command outputs a script that configures the <a href="https://www.gnu.org/software/bash/manual/html_node/Programmable-Completion" target="_blank" rel="noreferrer">programmable completion</a> of the <a href="https://www.gnu.org/software/bash" target="_blank" rel="noreferrer">bash</a> and <a href="https://www.zsh.org/" target="_blank" rel="noreferrer">zsh</a> Unix shells to recognize <code>teamscale-dev</code> and offer tab-completion for it.</p><div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">source</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &lt;( </span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">teamscale-dev</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> generate-completion )</span></span></code></pre></div><p>To permanently install tab-completion support for <code>teamscale-dev</code>, you can either place the above line in your shell&#39;s profile (e.g., <code>~/.bash_profile</code>) or save the output of <code>teamscale-dev generate-completion</code> to a file and execute it from there (e.g., by placing it in a <code>bash-completion.d</code> directory). Consult your operating system&#39;s documentation for the exact details.</p><h2 id="common-options" tabindex="-1">Common Options <a class="header-anchor" href="#common-options" aria-label="Permalink to &quot;Common Options&quot;">​</a></h2><p>Many command-line options are common to most if not all commands offered by <code>teamscale-dev</code>. These are described in the following.</p><p>In particular, you can use the help option, <code>--help</code>, built into all commands to list their respective options. For example:</p>',8)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[31]||(s[31]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --help")])])])],-1)])),_:1,__:[31]}),i(t,{label:"Windows"},{default:a(()=>s[32]||(s[32]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit --help")])])])],-1)])),_:1,__:[32]}),i(t,{label:"macOS"},{default:a(()=>s[33]||(s[33]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --help")])])])],-1)])),_:1,__:[33]})]),_:1}),s[63]||(s[63]=o('<h3 id="supplying-server-credentials" tabindex="-1">Supplying Server Credentials <a class="header-anchor" href="#supplying-server-credentials" aria-label="Permalink to &quot;Supplying Server Credentials&quot;">​</a></h3><p>Some commands like <a href="#the-pre-commit-command"><code>pre-commit</code></a>, <a href="#the-fetch-findings-command"><code>fetch-findings</code></a> or <a href="#the-open-in-browser-command"><code>open-in-browser</code></a> require you to supply your credentials for a Teamscale server, i.e., your <em>username</em> and <a href="./../../../glossary/#access-key"><em>access key</em></a>. You can pass these credentials to the commands in four ways:</p><ol><li><a href="#the-user-and-accesskey-command-line-options">The <code>--user</code> and <code>--accesskey</code> Command-Line Options</a></li><li><a href="#the-server-command-line-option">The <code>--server</code> Command-Line Option</a></li><li><a href="#the-teamscale-dev-servers-environment-variable">The <code>TEAMSCALE_DEV_SERVERS</code> Environment Variable</a></li><li><a href="#supplying-command-line-options-via-an-args-file">Supplying Command Line Options via an Args File</a></li></ol><div class="danger custom-block"><p class="custom-block-title">Accidentally Exposing the Access Key in Multi-User Environments</p><p>Passing the <a href="#the-user-and-accesskey-command-line-options"><code>--accesskey</code></a> or <a href="#the-server-command-line-option"><code>--server</code></a> options directly may accidentally expose your access key if other users on the same machine can inspect the command line of running commands (e.g., using <code>ps</code> or the <em>Task Manager</em>). Therefore it&#39;s <strong>highly recommended to either <a href="#the-teamscale-dev-servers-environment-variable">set the <code>TEAMSCALE_DEV_SERVERS</code> environment variable</a> or <a href="#supplying-command-line-options-via-an-args-file">supply command-line options via an args file</a></strong>.</p></div><h4 id="the-user-and-accesskey-command-line-options" tabindex="-1">The <code>--user</code> and <code>--accesskey</code> Command-Line Options <a class="header-anchor" href="#the-user-and-accesskey-command-line-options" aria-label="Permalink to &quot;The `--user` and `--accesskey` Command-Line Options&quot;">​</a></h4>',5)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[34]||(s[34]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --user"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," username"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --accesskey"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," accesskey"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[34]}),i(t,{label:"Windows"},{default:a(()=>s[35]||(s[35]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit --user username --accesskey accesskey ...")])])])],-1)])),_:1,__:[35]}),i(t,{label:"macOS"},{default:a(()=>s[36]||(s[36]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --user"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," username"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --accesskey"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," accesskey"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[36]})]),_:1}),s[64]||(s[64]=o('<p>These supply the username and access key to use for all servers referenced in the applicable <a href="./../../teamscale-toml/"><em>configuration files</em> (<code>.teamscale.toml</code>)</a>, unless they are configured explicitly using a <code>--server</code> option or the <code>TEAMSCALE_DEV_SERVERS</code> environment variable. (If you need to supply different credentials for different server URLs, you have to resort to one of the following alternatives.)</p><h4 id="the-server-command-line-option" tabindex="-1">The <code>--server</code> Command-Line Option <a class="header-anchor" href="#the-server-command-line-option" aria-label="Permalink to &quot;The `--server` Command-Line Option&quot;">​</a></h4>',2)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[37]||(s[37]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --server"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," https://username:accesskey@example.com/teamscale/"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[37]}),i(t,{label:"Windows"},{default:a(()=>s[38]||(s[38]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit --server https://username:accesskey"),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"@"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"example.com/teamscale/ ...")])])])],-1)])),_:1,__:[38]}),i(t,{label:"macOS"},{default:a(()=>s[39]||(s[39]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --server"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," https://username:accesskey@example.com/teamscale/"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[39]})]),_:1}),s[65]||(s[65]=o('<p>(You can use the <code>--server</code> option multiple times to supply credential URLs for multiple servers.)</p><h4 id="the-teamscale-dev-servers-environment-variable" tabindex="-1">The <code>TEAMSCALE_DEV_SERVERS</code> Environment Variable <a class="header-anchor" href="#the-teamscale-dev-servers-environment-variable" aria-label="Permalink to &quot;The `TEAMSCALE_DEV_SERVERS` Environment Variable&quot;">​</a></h4><div class="tip custom-block"><p class="custom-block-title">Recommended for Terminal Usage</p><p>Setting up the environment variable for your user is the most convenient option for usage of the CLI in a terminal since it allows you to omit any command-line options for credentials when using <code>teamscale-dev</code>.</p></div><p>You can set the <code>TEAMSCALE_DEV_SERVERS</code> environment variable for your user to supply the information from the <code>--server</code> command-line flags. It may contain multiple values of the <code>--server</code> command-line option separated by spaces.</p><p>On Linux and macOS add the following line to shell environment configuration file (e.g. <code>.bashrc</code> or <code>.zshrc</code> file in your user home directory).</p>',5)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[40]||(s[40]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"export"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," TEAMSCALE_DEV_SERVERS"),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"https://username:accesskey@example.com/teamscale/"')])])])],-1)])),_:1,__:[40]}),i(t,{label:"macOS"},{default:a(()=>s[41]||(s[41]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"export"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," TEAMSCALE_DEV_SERVERS"),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"https://username:accesskey@example.com/teamscale/"')])])])],-1)])),_:1,__:[41]})]),_:1}),s[66]||(s[66]=o('<p>On Windows follow these steps to set up a user specific environment variable.</p><ol><li>Click <em>Start</em> button</li><li>Search for <code>Accounts</code></li><li>Open <em>User Accounts</em></li><li>Go to <em>Tasks &gt; Change my environment variables</em></li><li>Add a new environment called <code>TEAMSCALE_DEV_SERVERS</code> with the following value:<div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>https://username:accesskey@example.com/teamscale/</span></span></code></pre></div></li></ol><h4 id="supplying-command-line-options-via-an-args-file" tabindex="-1">Supplying Command Line Options via an Args File <a class="header-anchor" href="#supplying-command-line-options-via-an-args-file" aria-label="Permalink to &quot;Supplying Command Line Options via an Args File&quot;">​</a></h4><p>You can use a so-called args file containing the <code>--server</code>, <code>--user</code> and <code>--accesskey</code> options from above to avoid access keys visible in your shell history or list of active processes. It&#39;s recommended to create this file in the user home directory of your operating system (i.e. <code>/home/&lt;username&gt;/.teamscale-dev.args</code> on Linux, <code>C:\\\\Users\\&lt;username&gt;</code> on Windows, <code>/Users/&lt;username&gt;/.teamscale-dev.args</code> on MacOS) to allow re-using it across multiple repositories.</p><p>Example content of <code>.teamscale-dev.args</code>:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>--server https://username:accesskey@example.com/teamscale/</span></span></code></pre></div><p>Then, include the options from the argument file using the <code>@</code>-notation:</p>',7)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[42]||(s[42]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' @"${'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"HOME"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'}/.teamscale-dev.args"'),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[42]}),i(t,{label:"Windows"},{default:a(()=>s[43]||(s[43]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"@"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"%HOMEPATH%\\.teamscale-dev.args ...")])])])],-1)])),_:1,__:[43]}),i(t,{label:"macOS"},{default:a(()=>s[44]||(s[44]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' @"${'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"HOME"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'}/.teamscale-dev.args"'),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[44]})]),_:1}),s[67]||(s[67]=o('<h4 id="credentials-precedence" tabindex="-1">Credentials Precedence <a class="header-anchor" href="#credentials-precedence" aria-label="Permalink to &quot;Credentials Precedence&quot;">​</a></h4><p>All four ways can be used at the same time. If different credentials are given for the same server URL, then the <code>--server</code> option takes precedence over the <code>TEAMSCALE_DEV_SERVERS</code> variable. Finally, the <code>--user</code> and <code>--accesskey</code> apply to any server whose credentials are not explicitly supplied via a credential URL. The command line options from an args file behave as if they were passed directly in its place.</p><h4 id="credential-url-format" tabindex="-1">Credential URL Format <a class="header-anchor" href="#credential-url-format" aria-label="Permalink to &quot;Credential URL Format&quot;">​</a></h4><p><em>Credential URLs</em> associate your username and accesskey with a Teamscale server&#39;s URL. They are constructed as follows:</p><p>If the Teamscale server&#39;s URL in your <a href="./../../teamscale-toml/"><em>configuration file</em> (<code>.teamscale.toml</code>)</a> is, for example, <code>https://example.com/teamscale/</code>, then the corresponding credential URL would look like <code>https://username:accesskey@example.com/teamscale/</code>, with <code>username</code> and <code>accesskey</code> replaced by your username and access key, respectively.</p><div class="warning custom-block"><p class="custom-block-title">Special Characters in Username and Access Key</p><p>Certain characters cannot be used verbatim in credential URLs; they need to be <a href="https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding" target="_blank" rel="noreferrer">percent-escaped</a>. In particular, this applies to the colon (<code>%3A</code>) and @-sign (<code>%40</code>). A username of <code>user@example.com</code>, for example, has to be written as <code>user%40example.com</code>.</p></div><p>Optionally, the credential URL can end with a <code>#trust-all-certificates</code> suffix, which <a href="#disabling-tls-certificate-validation">disables TLS certificate validation</a> for the server in question.</p><h3 id="disabling-tls-certificate-validation" tabindex="-1">Disabling TLS Certificate Validation <a class="header-anchor" href="#disabling-tls-certificate-validation" aria-label="Permalink to &quot;Disabling TLS Certificate Validation&quot;">​</a></h3><div class="danger custom-block"><p class="custom-block-title">Risk of Man-in-the-Middle Attacks</p><p>Disabling TLS certificate validation is insecure and increases the risk of successful man-in-the-middle attacks. It should only be done as a method of last resort or in testing environments.</p></div><p>Some commands like <a href="#the-pre-commit-command"><code>pre-commit</code></a> and <a href="#the-fetch-findings-command"><code>fetch-findings</code></a> connect to a Teamscale server. Such a connection may fail with a certificate-validation error when, for example, the server uses a self-signed certificate. In this case, you can disable TLS certificate validation in several ways:</p><ol><li><strong>The <code>--insecure</code> command-line option:</strong></li></ol>',11)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[45]||(s[45]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --insecure"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[45]}),i(t,{label:"Windows"},{default:a(()=>s[46]||(s[46]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit --insecure ...")])])])],-1)])),_:1,__:[46]}),i(t,{label:"macOS"},{default:a(()=>s[47]||(s[47]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --insecure"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[47]})]),_:1}),s[68]||(s[68]=e("ol",{start:"2"},[e("li",null,[e("strong",null,[l("The "),e("code",null,"--server"),l(" command-line option with "),e("code",null,"#trust-all-certificates"),l(" suffix:")])])],-1)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[48]||(s[48]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --server"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," https://username:accesskey@example.com/teamscale/#trust-all-certificates"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[48]}),i(t,{label:"Windows"},{default:a(()=>s[49]||(s[49]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit --server https://username:accesskey"),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"@"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"example.com/teamscale/#trust-all-certificates ...")])])])],-1)])),_:1,__:[49]}),i(t,{label:"macOS"},{default:a(()=>s[50]||(s[50]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --server"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," https://username:accesskey@example.com/teamscale/#trust-all-certificates"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[50]})]),_:1}),s[69]||(s[69]=e("ol",{start:"3"},[e("li",null,[e("strong",null,[l("The "),e("code",null,"TEAMSCALE_DEV_SERVERS"),l(" environment variable with "),e("code",null,"#trust-all-certificates"),l(" suffix:")])])],-1)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[51]||(s[51]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"export"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," TEAMSCALE_DEV_SERVERS"),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"https://username:accesskey@example.com/teamscale/#trust-all-certificates"')]),l(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[51]}),i(t,{label:"Windows"},{default:a(()=>s[52]||(s[52]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"setx"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," TEAMSCALE_DEV_SERVERS "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"https://username:accesskey@example.com/teamscale/#trust-all-certificates"')]),l(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe pre-commit ...")])])])],-1)])),_:1,__:[52]}),i(t,{label:"macOS"},{default:a(()=>s[53]||(s[53]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"export"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," TEAMSCALE_DEV_SERVERS"),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"https://username:accesskey@example.com/teamscale/#trust-all-certificates"')]),l(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," pre-commit"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ...")])])])],-1)])),_:1,__:[53]})]),_:1}),s[70]||(s[70]=o('<h3 id="overriding-branch-information" tabindex="-1">Overriding Branch Information <a class="header-anchor" href="#overriding-branch-information" aria-label="Permalink to &quot;Overriding Branch Information&quot;">​</a></h3><p>Some commands like <a href="#the-pre-commit-command"><code>pre-commit</code></a>, <a href="#the-fetch-findings-command"><code>fetch-findings</code></a>, and <a href="#the-open-in-browser-command"><code>open-in-browser</code></a> need to determine which branch has been checked out from the version-control system. This happens automatically for supported version-control systems (<a href="https://git-scm.com/" target="_blank" rel="noreferrer">Git</a>, <a href="https://subversion.apache.org/" target="_blank" rel="noreferrer">Subversion</a>). If your version-control system is unsupported by <code>teamscale-dev</code> or if you need to override the branch that has been automatically determined, you can override it explicitly.</p><p>In order of precedence, the branch is determined from these sources:</p><ol><li><code>--branch</code> command-line option</li><li><code>project.branch</code> property in your <a href="./../../teamscale-toml/">configuration file (<code>.teamscale.toml</code>)</a></li><li>Branch checked out from version control</li><li>Default branch of the respective Teamscale server</li></ol><h3 id="finding-output-format" tabindex="-1">Finding Output Format <a class="header-anchor" href="#finding-output-format" aria-label="Permalink to &quot;Finding Output Format&quot;">​</a></h3><p>Commands that report findings (e.g., <a href="#the-pre-commit-command"><code>pre-commit</code></a> or <a href="#the-fetch-findings-command"><code>fetch-findings</code></a>) do so in the <a href="https://gcc.gnu.org/onlinedocs/gcc/Diagnostic-Message-Formatting-Options.html" target="_blank" rel="noreferrer">GCC diagnostics format</a>:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>Path:Line:Column: (error|warning): Message</span></span></code></pre></div><ul><li><strong>Path</strong> is an absolute path to the (local) file for which findings are reported</li><li><strong>Line</strong> (starting with 1) and <strong>Column</strong> (always 1) numbers denote the first position within the file where the finding is found.</li><li><code>error</code> and <code>warning</code> corresponding to red and yellow findings, respectively.</li><li><strong>Message</strong> is the finding&#39;s descriptive message</li></ul><p>If the <code>--show-links-to-findings</code> command-line option is used, an extended format is used:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>Path:Line:Column: (error|warning): Message | (Link)</span></span></code></pre></div><ul><li><strong>Link</strong> is a URL to open the <a href="./../../ui/findings/#findings-detail-view"><em>Findings Detail</em> view</a> in a Web browser.</li></ul><p>By default, findings are reported to <em>stdout</em> but can be redirected to <em>stderr</em> by using the <code>--findings-to-stderr</code> command-line option.</p><h3 id="logging-debug-trace" tabindex="-1">Logging (<code>--debug</code>, <code>--trace</code>) <a class="header-anchor" href="#logging-debug-trace" aria-label="Permalink to &quot;Logging (`--debug`, `--trace`)&quot;">​</a></h3><p>In case any problems arise or you need to report an issue to our support, you can log debug or trace information by using the <code>--debug</code> or <code>--trace</code> options, respectively. These options are supported by all subcommands of <code>teamscale-dev</code>.</p><p>Optionally, you can refine which information is logged by specifying one or more categories. For example:</p>',15)),i(n,{sharedStateKey:"os"},{default:a(()=>[i(t,{label:"Linux"},{default:a(()=>s[54]||(s[54]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --debug"),e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}}," # --debug ALL")])])])],-1),e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --debug"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," FINDINGS,SERVERS"),e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}}," # --debug FINDINGS --debug SERVERS")])])])],-1)])),_:1,__:[54]}),i(t,{label:"Windows"},{default:a(()=>s[55]||(s[55]=[e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe --debug    "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"&"),e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}}," :: --debug ALL")])])])],-1),e("div",{class:"language-batch vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"batch"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale-dev.exe --debug FINDINGS,SERVERS   "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"&"),e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}}," :: --debug FINDINGS --debug SERVERS")])])])],-1)])),_:1,__:[55]}),i(t,{label:"macOS"},{default:a(()=>s[56]||(s[56]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --debug"),e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}}," # --debug ALL")])])])],-1),e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-dev"),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --debug"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," FINDINGS,SERVERS"),e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}}," # --debug FINDINGS --debug SERVERS")])])])],-1)])),_:1,__:[56]})]),_:1}),s[71]||(s[71]=o('<p>You can look up the exact list of supported categories using the <code>--help</code> option.</p><h2 id="license" tabindex="-1">License <a class="header-anchor" href="#license" aria-label="Permalink to &quot;License&quot;">​</a></h2><p>The <code>teamscale-dev</code> tool is licensed under the <a href="https://www.apache.org/licenses/LICENSE-2.0" target="_blank" rel="noreferrer">Apache License 2.0</a>.</p><p>Some third-party libraries included in the distribution may be subject to different license terms. For a full list of included libraries and their licenses, please refer to the <code>legal/</code> directory in the <code>teamscale-dev</code> distribution package.</p>',4))])}const F=h(p,[["render",m]]);export{f as __pageData,F as default};
