import{_ as a,h as t,ak as i,g as s}from"./chunks/framework.BpCjdwm5.js";const r="/assets/outgoing-connections.CK6FmKW7.png",n="/assets/incoming-connections.ZU0vUai8.png",f=JSON.parse('{"title":"Security","description":"","frontmatter":{"title":"Security"},"headers":[],"relativePath":"reference/security/index.md","filePath":"reference/security/index.md"}'),o={name:"reference/security/index.md"};function l(c,e,u,d,h,p){return s(),t("div",null,e[0]||(e[0]=[i('<h1 id="security-measures-for-teamscale-deployment" tabindex="-1">Security Measures for Teamscale Deployment <a class="header-anchor" href="#security-measures-for-teamscale-deployment" aria-label="Permalink to &quot;Security Measures for Teamscale Deployment&quot;">​</a></h1><p>We at CQSE take security of your data and source code very seriously.</p><div class="tip custom-block"><p class="custom-block-title">Most Importantly</p><p>In an on-premise deployment of Teamscale, <strong>none of your data leaves your own networks.</strong> Teamscale will never connect to remote servers unless you configure it to do so.</p><p>All required <a href="#connections-to-other-systems">network connections</a> to and from Teamscale <strong>can and should be encrypted.</strong></p></div><p>The goal of this article is to give a short overview of all security-relevant aspects of Teamscale and its integration into your infrastructure. We link to additional documentation in several places for a more detailed explanation.</p><nav class="table-of-contents"><ul><li><a href="#scope-of-this-article">Scope of This Article</a></li><li><a href="#deployment-and-permissions">Deployment and Permissions</a></li><li><a href="#updates-and-security-fixes">Updates and Security Fixes</a></li><li><a href="#security-measures-in-the-teamscale-server-application">Security Measures in the Teamscale Server Application</a><ul><li><a href="#authentication">Authentication</a></li><li><a href="#authorization">Authorization</a></li><li><a href="#logging">Logging</a></li><li><a href="#ssl-tls">SSL/TLS</a></li><li><a href="#data-encryption">Data Encryption</a></li><li><a href="#backups">Backups</a></li></ul></li><li><a href="#connections-to-other-systems">Connections to Other Systems</a></li><li><a href="#additional-security-measures-for-teamscale-cloud">Additional Security Measures for Teamscale Cloud</a><ul><li><a href="#virtual-machines-for-data-separation">Virtual Machines for Data Separation</a></li><li><a href="#encryption-at-rest-and-in-transit">Encryption at Rest and in Transit</a></li><li><a href="#authentication-1">Authentication</a></li><li><a href="#backups-1">Backups</a></li><li><a href="#access-management">Access Management</a></li></ul></li></ul></nav><h2 id="scope-of-this-article" tabindex="-1">Scope of This Article <a class="header-anchor" href="#scope-of-this-article" aria-label="Permalink to &quot;Scope of This Article&quot;">​</a></h2><p>This article only deals with the security measures around the Teamscale server application. For information about our security policies and processes, please refer to the <a href="./../../terms/tom/">Technical and Organizational Security Measures</a> .</p><p>Teamscale can be installed on your own servers (on-premise) or used as a service in the cloud. Most security measures apply to both scenarios. If you install Teamscale on your own servers, you are of course responsible to apply suitable security measures to the host operating system and operating environment of all the installed tools, which is outside the scope of this article. For users of our cloud offering, a dedicated section below provides more information about additional <a href="#additional-security-measures-for-teamscale-cloud">Security Measures for Teamscale Cloud</a>.</p><h2 id="deployment-and-permissions" tabindex="-1">Deployment and Permissions <a class="header-anchor" href="#deployment-and-permissions" aria-label="Permalink to &quot;Deployment and Permissions&quot;">​</a></h2><p>There are two deployment modes, both of which use the least possible privileges. When <a href="./../../getting-started/installing-teamscale/">installed as an operating system service</a>, Teamscale does not require root or administrative privileges. When running Teamscale as a <a href="./../../howto/installing-teamscale/installing-with-docker/">Docker container</a>, the Teamscale process does not run as root inside the Docker container. Additionally, the container is self-contained, i.e. all required services are included in the container image.</p><h2 id="updates-and-security-fixes" tabindex="-1">Updates and Security Fixes <a class="header-anchor" href="#updates-and-security-fixes" aria-label="Permalink to &quot;Updates and Security Fixes&quot;">​</a></h2><p>We provide new Teamscale versions on a regular basis:</p><ul><li>Major releases with new features: every 6 weeks</li><li>Patch releases with bug and security fixes: at least every week for at least the latest two major releases</li></ul><p>For severe security issues, such as <a href="https://en.wikipedia.org/wiki/Log4Shell" target="_blank" rel="noreferrer">Log4Shell</a>, we often provide fixed versions within a single day.</p><h2 id="security-measures-in-the-teamscale-server-application" tabindex="-1">Security Measures in the Teamscale Server Application <a class="header-anchor" href="#security-measures-in-the-teamscale-server-application" aria-label="Permalink to &quot;Security Measures in the Teamscale Server Application&quot;">​</a></h2><h3 id="authentication" tabindex="-1">Authentication <a class="header-anchor" href="#authentication" aria-label="Permalink to &quot;Authentication&quot;">​</a></h3><p>We recommend you configure LDAP, Active Directory or Single sign-on as your authentication provider. In this case, human users log into Teamscale with their LDAP credentials. Credentials are forwarded to and verified by the LDAP server/SSO/Active Directory.</p><p>Technical users authenticate themselves in Teamscale with an access token. Tokens can be revoked and regenerated in Teamscale.</p><h3 id="authorization" tabindex="-1">Authorization <a class="header-anchor" href="#authorization" aria-label="Permalink to &quot;Authorization&quot;">​</a></h3><p>Teamscale has a <a href="./../permission-management/">fine-grained permission model</a> including permission management with roles and rights for both technical and human users.</p><p>Naturally, access to Teamscale projects can be granted selectively, enabling you to effectively segregate sensitive information and control which groups of people can see and modify what.</p><h3 id="logging" tabindex="-1">Logging <a class="header-anchor" href="#logging" aria-label="Permalink to &quot;Logging&quot;">​</a></h3><p>Teamscale’s log files are stored on-disk and must be secured with the host operating system’s permission system by you.</p><p>Some log files can also be accessed via Teamscale&#39;s web interface by Teamscale administrators. Access to these is secured by Teamscale’s <a href="./../permission-management/">permission management system</a>.</p><p>The following security-related events are logged by Teamscale:</p><ul><li>failed login attempts (passwords are not logged, of course)</li><li>invalid API requests (access tokens are not logged, of course)</li></ul><p>By default, logs are rotated regularly.</p><h3 id="ssl-tls" tabindex="-1">SSL/TLS <a class="header-anchor" href="#ssl-tls" aria-label="Permalink to &quot;SSL/TLS&quot;">​</a></h3><p>Teamscale&#39;s web interface can be <a href="./../../howto/configuring-https/">configured to be served via HTTPS</a>. When running on-premise, you need to provide the required certificates and key files yourself.</p><p>However, for a productive setup, we recommend you terminate SSL yourself, e.g., by placing a reverse proxy like <a href="https://www.nginx.com/" target="_blank" rel="noreferrer">Nginx</a> before Teamscale. This gives you additional flexibility and usually has better performance.</p><h3 id="data-encryption" tabindex="-1">Data Encryption <a class="header-anchor" href="#data-encryption" aria-label="Permalink to &quot;Data Encryption&quot;">​</a></h3><p>In addition to existing disk encryption, Teamscale stores sensitive data in the internal database and any backups in an encrypted fashion by default. Examples include personal data of users and credentials for external systems Teamscale connects to. Additionally, you can set the <a href="./../administration-ts-installation/#jvm-settings-jvm-properties">JVM property</a> <code>com.teamscale.crypto.encrypt-all</code> to encrypt the complete internal database. However, this may reduce Teamscale&#39;s performance and result in slower developer feedback. A custom encryption key can be provided.</p><h3 id="backups" tabindex="-1">Backups <a class="header-anchor" href="#backups" aria-label="Permalink to &quot;Backups&quot;">​</a></h3><p>Teamscale can be configured to <a href="./../../howto/handling-backups/">automatically create backups</a> of the configuration and all uploaded data in regular intervals. These include all information needed to restore a Teamscale instance, but not the code and ticket data obtained from third-party systems. They are stored on-disk as zip files.</p><p>Backups can be configured, so they are automatically rotated in configurable intervals.</p><p>Backups can be encrypted symmetrically. A custom encryption key can be provided.</p><h2 id="connections-to-other-systems" tabindex="-1">Connections to Other Systems <a class="header-anchor" href="#connections-to-other-systems" aria-label="Permalink to &quot;Connections to Other Systems&quot;">​</a></h2><p>Teamscale needs to connect to and integrate with other systems in your infrastructure. Which exact systems it requires access to depends on which features of Teamscale you intend to use.</p><p><img src="'+r+'" alt="Diagram of Connections from Teamscale to Other Systems" width="960" height="540" data-zoom="true"><img src="'+n+'" alt="Diagram of Connections from Other Systems to Teamscale" width="960" height="540" data-zoom="true"></p><p>For further information about these connections and their authentication mechanisms, as well as required permissions for Teamscale&#39;s technical users in these tools, see the respective part of our documentation:</p><p>Issue Trackers and Requirements Management:</p><ul><li><a href="./../../howto/connecting-to-issue-trackers/jira/">Jira</a></li><li><a href="./../../howto/connecting-requirements-management-tool/polarion/">Polarion</a></li></ul><p>Version Control Systems and Code Collaboration Platforms:</p><ul><li><a href="./../../howto/connecting-version-control-system/github/">GitHub</a></li><li><a href="./../../howto/connecting-version-control-system/gitlab/">GitLab</a></li><li><a href="./../../howto/connecting-version-control-system/bitbucket/">Bitbucket</a></li><li><a href="./../../howto/connecting-version-control-system/git-with-ssh/">Git via SSH</a></li><li><a href="./../../howto/connecting-version-control-system/azure-devops-git/">Azure DevOps Git</a></li><li><a href="./../../howto/connecting-version-control-system/azure-devops-tfvc/">Azure DevOps TFVC</a></li><li><a href="./../../howto/connecting-version-control-system/scm-manager/">SCM Manager</a></li><li><a href="./../../tutorial/sap-integration/">SAP® Systems</a></li></ul><p>Authentication and Single sign-on (SSO):</p><ul><li><a href="./../../howto/importing-users/">Active Directory, LDAP</a></li><li><a href="./../../howto/importing-users/#using-azure-devops-authorization-formerly-tfs-authorization-server">Azure DevOps Authorization Server</a></li><li><a href="./../../howto/importing-users/#single-sign-on-using-saml-2-0-or-openid-connect">Single sign-on with SAML 2.0 and OpenID Connect</a></li></ul><p>Build and Test Environments:</p><ul><li><a href="./../../howto/uploading-external-data/#upload-via-command-line">Upload of external analysis data</a>, e.g. test coverage, results of checkers run in your build, ...</li></ul><p>IDE Plugins:</p><ul><li><a href="./../../getting-started/eclipse/">Eclipse</a></li><li><a href="./../../getting-started/intellij/">IntelliJ</a></li><li><a href="./../../getting-started/visual-studio/">Visual Studio</a></li><li><a href="./../../getting-started/other-ides/">Visual Studio Code, Sublime Text, Vim, XCode and others</a></li></ul><h2 id="additional-security-measures-for-teamscale-cloud" tabindex="-1">Additional Security Measures for Teamscale Cloud <a class="header-anchor" href="#additional-security-measures-for-teamscale-cloud" aria-label="Permalink to &quot;Additional Security Measures for Teamscale Cloud&quot;">​</a></h2><p>The Teamscale instances that we run in the cloud, are subject to additional security measures. Please also refer to the <a href="./../../terms/tom/">Technical and Organizational Security Measures</a> for information about our security policies and processes.</p><h3 id="virtual-machines-for-data-separation" tabindex="-1">Virtual Machines for Data Separation <a class="header-anchor" href="#virtual-machines-for-data-separation" aria-label="Permalink to &quot;Virtual Machines for Data Separation&quot;">​</a></h3><p>Teamscale is hosted on virtual servers and runs inside a container solution. Teamscale instances of other tenants are separated using individual virtual servers.</p><h3 id="encryption-at-rest-and-in-transit" tabindex="-1">Encryption at Rest and in Transit <a class="header-anchor" href="#encryption-at-rest-and-in-transit" aria-label="Permalink to &quot;Encryption at Rest and in Transit&quot;">​</a></h3><p>All data is encrypted both at rest and in transit using strong state-of-the-art encryption algorithms. Network connections are protected using TLS and all disks are encrypted as well.</p><h3 id="authentication-1" tabindex="-1">Authentication <a class="header-anchor" href="#authentication-1" aria-label="Permalink to &quot;Authentication&quot;">​</a></h3><p>If you can provide an Internet facing SAML 2.0 identity provider, we can integrate with this single sign-on (SSO) solution. Alternatively, we can configure one of the other authentication providers supported by Teamscale (LDAP, Active Directory, Azure DevOps Authorization Server, OpenID Connect), if the required servers are reachable from our cloud servers. As a fallback, users and passwords can also be managed using Teamscale&#39;s built-in user management.</p><h3 id="backups-1" tabindex="-1">Backups <a class="header-anchor" href="#backups-1" aria-label="Permalink to &quot;Backups&quot;">​</a></h3><p>Snapshot backups of the server are created every night and stored in encrypted fashion for up to 14 days. In addition, encrypted backups of the Teamscale instance configuration and user data are created daily and kept for 7 consecutive days, 4 consecutive weeks and 3 consecutive months.</p><h3 id="access-management" tabindex="-1">Access Management <a class="header-anchor" href="#access-management" aria-label="Permalink to &quot;Access Management&quot;">​</a></h3><p>Access to the cloud infrastructure is limited to a small group of dedicated administrators, who are regularly trained and instructed according to CQSE&#39;s security policies. Direct access to instances and servers is kept to the required minimum, respecting the need-to-know principle.</p>',62)]))}const y=a(o,[["render",l]]);export{f as __pageData,y as default};
