/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.datahandler.ESimulinkColor;
import org.conqat.lib.simulink.model.datahandler.FontData;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LayoutHandlerBase;
import org.conqat.lib.simulink.model.datahandler.LineLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkColorUtils;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkPortLayoutUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SimulinkLineLayoutUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> UNFIXED_SOURCE_BLOCKS = CollectionUtils.asHashSet((Object[])new String[]{"Inport", "InportShadow", "BusSelector"});

    public static LineLayoutData extractLineLayoutData(SimulinkLine line) {
        List<Point> points = SimulinkLineLayoutUtils.extractLinePoints(line);
        Color color = line.hasUnconnectedEndpoint() ? ESimulinkColor.RED.getColor() : SimulinkColorUtils.extractColor(line.getSrcPort().getBlock(), "ForegroundColor", Color.BLACK);
        return new LineLayoutData(points, color);
    }

    private static List<Point> extractLinePoints(SimulinkLine line) {
        ArrayList<Point> points = new ArrayList<Point>();
        boolean firstPointIsFixed = false;
        if (line.getSrcPort() != null && line.getSrcPort().getFlexiblePortPlacementParameters().isPresent()) {
            points.add(line.getSrcPort().obtainLayoutData().getPosition());
            firstPointIsFixed = true;
        } else if (line.getSrcPort() != null) {
            points.add(line.getSrcPort().obtainLayoutData().getPosition());
            Point sourceBend = SimulinkPortLayoutUtils.getPrePortPoint(line.getSrcPort(), line.getSrcPort().getBlock().obtainBlockLayoutData());
            points.add(sourceBend);
        }
        SimulinkLineLayoutUtils.extractPoints(line, points);
        if (line.getDstPort() != null && line.getDstPort().getFlexiblePortPlacementParameters().isPresent()) {
            points.add(line.getDstPort().obtainLayoutData().getPosition());
        } else if (line.getDstPort() != null) {
            SimulinkBlock destinationBlock = line.getDstPort().getBlock();
            points.add(SimulinkPortLayoutUtils.getPrePortPoint(line.getDstPort(), destinationBlock.obtainBlockLayoutData()));
            SimulinkLineLayoutUtils.fixPrepointIfNeeded(points);
            points.add(line.getDstPort().obtainLayoutData().getPosition());
            SimulinkLineLayoutUtils.fixPrepointIfNeeded(points);
        }
        if (SimulinkLineLayoutUtils.isInportToSubsystemLine(line) && !firstPointIsFixed) {
            Collections.reverse(points);
            SimulinkLineLayoutUtils.straightenLine(points, false);
            Collections.reverse(points);
        } else if (SimulinkLineLayoutUtils.lineCanBeFixed(line)) {
            SimulinkLineLayoutUtils.straightenLine(points, firstPointIsFixed);
        }
        return points;
    }

    private static void fixPrepointIfNeeded(List<Point> points) {
        if (points.size() >= 3) {
            SimulinkLineLayoutUtils.fixPrepointIfNeeded(points.get(points.size() - 3), points.get(points.size() - 2), points.get(points.size() - 1));
        }
    }

    private static void fixPrepointIfNeeded(Point pointBefore, Point prePoint, Point pointAfter) {
        boolean allPointsHaveSameY;
        boolean allPointsHaveSameX;
        boolean bl = allPointsHaveSameX = pointBefore.x == pointAfter.x && prePoint.x == pointAfter.x;
        if (allPointsHaveSameX && (pointBefore.y <= pointAfter.y && prePoint.y < pointBefore.y || pointBefore.y >= pointAfter.y && prePoint.y > pointBefore.y)) {
            prePoint.y = pointBefore.y;
        }
        boolean bl2 = allPointsHaveSameY = pointBefore.y == pointAfter.y && prePoint.y == pointAfter.y;
        if (allPointsHaveSameY && (pointBefore.x <= pointAfter.x && prePoint.x < pointBefore.x || pointBefore.x >= pointAfter.x && prePoint.x > pointBefore.x)) {
            prePoint.x = pointBefore.x;
        }
    }

    private static boolean isInportToSubsystemLine(SimulinkLine line) {
        return !line.hasUnconnectedEndpoint() && SimulinkUtils.isInport(line.getSrcPort().getBlock()) && (line.getDstPort().getBlock().isOfType("SubSystem") || SimulinkLineLayoutUtils.isBigBlock(line.getDstPort().getBlock()));
    }

    private static boolean isBigBlock(SimulinkBlock block) {
        Rectangle position = block.obtainBlockLayoutData().getPosition();
        return position.getWidth() > 100.0 && position.getHeight() > 100.0;
    }

    private static boolean lineCanBeFixed(SimulinkLine line) {
        return !line.hasUnconnectedEndpoint() && line.getSrcPort().getLines().size() == 1 && !UNFIXED_SOURCE_BLOCKS.contains(line.getSrcPort().getBlock().getType());
    }

    private static void straightenLine(List<Point> points, boolean firstPointIsFixed) {
        int pointsSize = points.size();
        if (pointsSize < 3) {
            return;
        }
        Point last = points.get(pointsSize - 1);
        Point last1 = points.get(pointsSize - 2);
        Point last2 = points.get(pointsSize - 3);
        int deltaX = last.x - last1.x;
        int deltaY = last.y - last1.y;
        int deltaX1 = last1.x - last2.x;
        int deltaY1 = last1.y - last2.y;
        if (deltaX == 0) {
            if (deltaX1 != 0 && Math.abs(deltaX1) <= 5) {
                List<Point> pointsToMove = points.subList(0, pointsSize - 2);
                if (firstPointIsFixed) {
                    pointsToMove = pointsToMove.subList(1, pointsToMove.size());
                }
                SimulinkLineLayoutUtils.moveLinePoints(pointsToMove, deltaX1, 0);
            }
        } else if (deltaY == 0 && Math.abs(deltaY1) <= 8 && deltaY1 != 0) {
            List<Point> pointsToMove = points.subList(0, pointsSize - 2);
            if (firstPointIsFixed) {
                pointsToMove = pointsToMove.subList(1, pointsToMove.size());
            }
            SimulinkLineLayoutUtils.moveLinePoints(pointsToMove, 0, deltaY1);
        }
    }

    private static void moveLinePoints(List<Point> points, int deltaX, int deltaY) {
        for (int i = 0; i < points.size(); ++i) {
            points.get(i).translate(deltaX, deltaY);
        }
    }

    private static void extractPoints(SimulinkLine line, List<Point> points) {
        String pointsText = line.getParameter("Points");
        if (pointsText == null) {
            return;
        }
        try {
            int[] pointsArray = SimulinkUtils.getIntParameterArray(pointsText);
            for (int i = 0; i < pointsArray.length / 2; ++i) {
                Point point = new Point(pointsArray[2 * i], pointsArray[2 * i + 1]);
                if (!points.isEmpty()) {
                    Point lastPoint = (Point)CollectionUtils.getLast(points);
                    point.x += lastPoint.x;
                    point.y += lastPoint.y;
                }
                points.add(point);
                SimulinkLineLayoutUtils.fixPrepointIfNeeded(points);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("Points array contained invalid number: " + pointsText + ". Skipping points.");
        }
    }

    public static @NonNull List<LabelLayoutData> extractLineLabelLayoutData(SimulinkLine line, LineLayoutData lineLayoutData, FontData font) {
        return SimulinkLineLayoutUtils.extractLineLabelLayoutData(line, lineLayoutData, font, null);
    }

    public static @NonNull List<LabelLayoutData> extractLineLabelLayoutData(SimulinkLine line, LineLayoutData lineLayoutData, FontData font, @Nullable SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        String text;
        int[] labels = SimulinkLineLayoutUtils.extractLineLabels(line);
        if (labels == null) {
            return Collections.emptyList();
        }
        List<Point> points = lineLayoutData.getPoints();
        if (line.getSrcPort() == null) {
            points.add(0, points.get(0));
        }
        if (StringUtils.isEmpty((String)(text = SimulinkLineLayoutUtils.determineLineLabelText(line, propagatedSignalLabels)))) {
            return Collections.emptyList();
        }
        text = SimulinkUtils.replaceSimulinkLineBreaks(text);
        ArrayList<LabelLayoutData> result = new ArrayList<LabelLayoutData>();
        for (int i = 0; i < labels.length - 1; i += 2) {
            int segment = labels[i];
            if (segment + 1 >= points.size()) {
                LOGGER.error("Invalid segment " + segment + " used for line " + text);
                return Collections.emptyList();
            }
            Point position = SimulinkLineLayoutUtils.calculateLineLabelPosition(segment, labels[i + 1], points, LayoutHandlerBase.determineTextBounds(text, font.getAwtFont()));
            Color color = Color.BLACK;
            if (!line.hasUnconnectedEndpoint()) {
                color = lineLayoutData.getColor();
            }
            result.add(new LabelLayoutData(text, true, font, position, color, 1.0));
        }
        return result;
    }

    public static String determineLineLabelText(SimulinkLine line) {
        return SimulinkLineLayoutUtils.determineLineLabelText(line, null);
    }

    public static String determineLineLabelText(SimulinkLine line, @Nullable SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        SimulinkOutPort srcPort = line.getSrcPort();
        String currentSignalName = line.getParameter("Name");
        if (srcPort == null) {
            return currentSignalName;
        }
        String showPropagatedParameter = srcPort.getParameter("ShowPropagatedSignals");
        boolean showPropagated = "on".equals(showPropagatedParameter);
        if (!showPropagated) {
            return currentSignalName;
        }
        String propagatedSignalName = SimulinkUtils.getPropagatedSignalName(srcPort, propagatedSignalLabels);
        String propagateSignalNameFormatted = "<" + StringUtils.emptyIfNull((String)propagatedSignalName) + ">";
        if (currentSignalName != null) {
            return currentSignalName + " " + propagateSignalNameFormatted;
        }
        return propagateSignalNameFormatted;
    }

    private static int[] extractLineLabels(SimulinkLine line) {
        int[] labels;
        String labelsString = line.getParameter("Labels");
        if (labelsString == null) {
            return null;
        }
        try {
            labels = SimulinkUtils.getIntParameterArray(labelsString);
            if (labels.length < 2) {
                LOGGER.error("Invalid line labels: " + labelsString);
                return null;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("Had invalid labels parameter: " + labelsString);
            return null;
        }
        return labels;
    }

    public static @Nullable LabelLayoutData extractTypeLabelLayoutData(SimulinkLine line, LineLayoutData lineLayoutData, FontData font, @Nullable SimulinkResolvedDataTypes propagatedDataTypes) {
        if (propagatedDataTypes == null) {
            return null;
        }
        SimulinkOutPort srcPort = line.getSrcPort();
        if (srcPort == null) {
            return null;
        }
        String dataType = propagatedDataTypes.getResolvedOutputDataTypesForBlock(srcPort.getBlock(), srcPort.getIndex());
        if (dataType == null) {
            return null;
        }
        int segment = 0;
        List<Point> points = lineLayoutData.getPoints();
        if (points.size() <= segment + 1) {
            LOGGER.error("Not enough points on line");
            return null;
        }
        int side = SimulinkLineLayoutUtils.suggestSide(SimulinkLineLayoutUtils.extractLineLabels(line), segment, 1);
        Point position = SimulinkLineLayoutUtils.calculateLineLabelPosition(segment, side, points, LayoutHandlerBase.determineTextBounds(dataType, font.getAwtFont()));
        return new LabelLayoutData(dataType, true, font, position, Color.DARK_GRAY, 1.0);
    }

    @VisibleForTesting
    static int suggestSide(int @Nullable [] lineLabels, int segment, int desiredSide) {
        if (lineLabels == null) {
            return desiredSide;
        }
        int i = 0;
        while (i + 1 < lineLabels.length) {
            int lineLabelSegment = lineLabels[i];
            int lineLabelSide = lineLabels[i + 1];
            if (segment == lineLabelSegment) {
                if (lineLabelSide != desiredSide) {
                    return desiredSide;
                }
                return lineLabelSide == 0 ? 1 : 0;
            }
            i += 2;
        }
        return desiredSide;
    }

    private static Point calculateLineLabelPosition(int segment, int side, List<Point> points, Rectangle textBounds) {
        boolean rightAligned;
        boolean bl = rightAligned = segment < 0;
        if (rightAligned) {
            segment = points.size() - 2;
        }
        int x1 = points.get((int)segment).x;
        int x2 = points.get((int)(segment + 1)).x;
        double x = (double)(x2 + x1) / 2.0;
        int y1 = points.get((int)segment).y;
        int y2 = points.get((int)(segment + 1)).y;
        double y = (double)(y2 + y1) / 2.0;
        if (x2 == x1) {
            boolean linePointsDownwards;
            y -= (double)textBounds.height / 2.0;
            x = side == 0 ^ (linePointsDownwards = y1 > y2) ? (x += 4.0) : (x -= (double)(textBounds.width - 4));
        } else {
            boolean linePointsRight;
            boolean bl2 = linePointsRight = x1 < x2;
            x = rightAligned && linePointsRight || segment == 0 && !linePointsRight ? (double)(x2 - textBounds.width - 4) : (segment > 0 && !rightAligned ? (x -= (double)textBounds.width / 2.0) : (x += 4.0));
            y = side == 0 ^ linePointsRight ^ segment == 0 ^ rightAligned ? (y += 4.0) : (y -= (double)(textBounds.height + 4));
        }
        return new Point((int)x, (int)y);
    }
}

