/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.targetlink;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.visitor.IVisitor;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class TargetLinkUtils {
    private static final String TARGETLINK_BLOCK_PREFIX = "TL_";

    public static void filterSyntheticBlocks(SimulinkModel model) throws SimulinkModelBuildingException {
        SimulinkBlock simFrameBlock = TargetLinkUtils.obtainSimFrameBlock(model);
        if (simFrameBlock == null) {
            return;
        }
        String name = simFrameBlock.getName();
        SimulinkBlock subsystem = simFrameBlock.getSubBlock("Subsystem");
        CCSMAssert.isNotNull((Object)subsystem, (String)String.format("The SimFrame Block has no sub-block with name \"%s\"", "Subsystem"));
        SimulinkBlock block = subsystem.getSubBlock(name);
        CCSMAssert.isNotNull((Object)block, (String)String.format("The SimFrame/Subsystem block has no sub-block with name %s", name));
        TargetLinkUtils.replaceBlock(simFrameBlock, block, "Position", "BackgroundColor");
    }

    @VisibleForTesting
    static SimulinkBlock obtainSimFrameBlock(SimulinkModel model) {
        SyntheticBlockFindingVisitor visitor = new SyntheticBlockFindingVisitor();
        SimulinkUtils.visitDepthFirst(model, visitor);
        return visitor.getSimFrameBlock();
    }

    private static SimulinkLine replaceLine(SimulinkLine line, SimulinkOutPort sourcePort, SimulinkInPort destinationPort, String ... parameters) {
        HashMap<String, String> paramValues = new HashMap<String, String>();
        for (String param : parameters) {
            String value = line.getParameter(param);
            paramValues.put(param, value);
        }
        line.remove();
        SimulinkBlock newContainer = SimulinkUtils.getLowestCommonAncestor(sourcePort.getBlock().getParent(), destinationPort.getBlock().getParent());
        SimulinkLine newLine = new SimulinkLine(sourcePort, destinationPort, newContainer);
        for (String param : parameters) {
            String value = (String)paramValues.get(param);
            if (value == null) continue;
            newLine.setParameter(param, value);
        }
        return newLine;
    }

    private static void replaceBlock(SimulinkBlock oldBlock, SimulinkBlock replacement, String ... parameters) throws SimulinkModelBuildingException {
        if (!TargetLinkUtils.checkCompatibility(oldBlock, replacement)) {
            throw new SimulinkModelBuildingException("Blocks are not compatible!");
        }
        replacement.getInLines().forEach(SimulinkLine::remove);
        TargetLinkUtils.redirectInPorts(oldBlock, replacement);
        replacement.getOutLines().forEach(SimulinkLine::remove);
        TargetLinkUtils.redirectOutPorts(oldBlock, replacement);
        CCSMAssert.isTrue((boolean)oldBlock.getInLines().isEmpty(), (String)"In-lines have not been properly replaced");
        CCSMAssert.isTrue((boolean)oldBlock.getOutLines().isEmpty(), (String)"Out-lines have not been properly replaced");
        SimulinkBlock parent = oldBlock.getParent();
        oldBlock.detach();
        replacement.detach();
        parent.addSubBlock(replacement);
        for (String name : parameters) {
            String value = oldBlock.getParameter(name);
            if (value == null) continue;
            replacement.setParameter(name, value);
        }
        oldBlock.remove();
    }

    private static void redirectInPorts(SimulinkBlock blockToChange, SimulinkBlock newFromBlock) throws SimulinkModelBuildingException {
        for (SimulinkInPort port : blockToChange.getInPorts()) {
            TargetLinkUtils.redirectInPort(port, newFromBlock);
        }
    }

    private static void redirectOutPorts(SimulinkBlock blockToChange, SimulinkBlock newTargetBlock) throws SimulinkModelBuildingException {
        for (SimulinkOutPort port : blockToChange.getOutPorts()) {
            TargetLinkUtils.redirectOutPort(port, newTargetBlock);
        }
    }

    private static void redirectInPort(SimulinkInPort oldInPort, SimulinkBlock target) throws SimulinkModelBuildingException {
        SimulinkLine line = oldInPort.getLine();
        if (line == null) {
            return;
        }
        SimulinkInPort newInPort = target.getInPort(oldInPort.getIndex());
        if (newInPort == null) {
            throw new SimulinkModelBuildingException("Port could not be redirected.");
        }
        TargetLinkUtils.replaceLine(line, line.getSrcPort(), newInPort, "Points");
    }

    private static void redirectOutPort(SimulinkOutPort oldOutPort, SimulinkBlock target) throws SimulinkModelBuildingException {
        SimulinkOutPort newOutPort = target.getOutPort(oldOutPort.getIndex());
        if (newOutPort == null) {
            throw new SimulinkModelBuildingException("Port could not be redirected.");
        }
        HashSet<SimulinkLine> lines = new HashSet<SimulinkLine>((Collection<SimulinkLine>)oldOutPort.getLines());
        for (SimulinkLine line : lines) {
            TargetLinkUtils.replaceLine(line, newOutPort, line.getDstPort(), "Points");
        }
    }

    public static boolean isTargetlinkBlock(SimulinkBlock block) {
        return TargetLinkUtils.isTargetlinkBlockReference(block) || TargetLinkUtils.isTargetlinkMaskType(block) || TargetLinkUtils.hasTargetlinkObject(block);
    }

    private static boolean isTargetlinkBlockReference(SimulinkBlock block) {
        return block.isOfType("Reference") && block.getSourceType() != null && block.getSourceType().startsWith(TARGETLINK_BLOCK_PREFIX);
    }

    public static boolean isTargetlinkMaskType(SimulinkBlock block) {
        String maskType = block.getParameter("MaskType");
        if (maskType == null) {
            maskType = block.getParameter("Mask.Type");
        }
        return maskType != null && maskType.startsWith(TARGETLINK_BLOCK_PREFIX);
    }

    private static boolean hasTargetlinkObject(SimulinkBlock block) {
        SimulinkObject maskObject = SimulinkUtils.findObjectByClass(block, "Simulink.Mask");
        if (maskObject == null) {
            return false;
        }
        String typeParameter = maskObject.getParameter("Type");
        return typeParameter != null && typeParameter.startsWith(TARGETLINK_BLOCK_PREFIX);
    }

    private static boolean checkCompatibility(SimulinkBlock block1, SimulinkBlock block2) {
        boolean inPortsEqual = TargetLinkUtils.obtainPortIndexes(block1.getInPorts()).equals(TargetLinkUtils.obtainPortIndexes(block2.getInPorts()));
        boolean outPortsEqual = TargetLinkUtils.obtainPortIndexes(block1.getOutPorts()).equals(TargetLinkUtils.obtainPortIndexes(block2.getOutPorts()));
        return inPortsEqual && outPortsEqual;
    }

    private static HashSet<String> obtainPortIndexes(Collection<? extends SimulinkPortBase> ports) {
        HashSet<String> indexes = new HashSet<String>();
        for (SimulinkPortBase simulinkPortBase : ports) {
            indexes.add(simulinkPortBase.getIndex());
        }
        return indexes;
    }

    private static class SyntheticBlockFindingVisitor
    implements IVisitor<SimulinkBlock, NeverThrownRuntimeException> {
        private SimulinkBlock simFrameBlock;

        private SyntheticBlockFindingVisitor() {
        }

        public void visit(SimulinkBlock element) throws NeverThrownRuntimeException {
            String maskType = element.getParameter("MaskType");
            if ("TL_SimFrame".equals(maskType)) {
                CCSMAssert.isTrue((this.simFrameBlock == null ? 1 : 0) != 0, (String)"We assume that there's only one TL_Simframe block in a model. This assumption is violated.");
                this.simFrameBlock = element;
            }
        }

        public SimulinkBlock getSimFrameBlock() {
            return this.simFrameBlock;
        }
    }
}

