/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.TransitionLayoutData;
import org.conqat.lib.simulink.model.stateflow.IStateflowChartContainer;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class StateflowUtils {
    public static int countStates(IStateflowNodeContainer<?> node) {
        int count = 0;
        if (node instanceof StateflowState) {
            count = 1;
        }
        for (StateflowNodeBase element : node.getNodes()) {
            if (!(element instanceof IStateflowNodeContainer)) continue;
            count += StateflowUtils.countStates((IStateflowNodeContainer)((Object)element));
        }
        if (node instanceof StateflowState && ((StateflowState)node).isSubChart()) {
            count += StateflowUtils.countStates(((StateflowState)node).getSubViewer());
        }
        return count;
    }

    public static int countStates(StateflowMachine stateflowMachine) {
        int stateCount = 0;
        for (StateflowChart chart : stateflowMachine.getCharts()) {
            stateCount += StateflowUtils.countStates(chart);
        }
        return stateCount;
    }

    public static StateflowChart getChart(IStateflowElement<?> element) {
        if (element instanceof StateflowChart) {
            return (StateflowChart)element;
        }
        Object parent = element.getParent();
        if (parent == null) {
            return null;
        }
        return StateflowUtils.getChart(parent);
    }

    public static StateflowBlock getBlock(IStateflowElement<?> element) {
        StateflowChart chart = StateflowUtils.getChart(element);
        if (chart == null) {
            return null;
        }
        return chart.getStateflowBlock();
    }

    public static String getStateName(StateflowState state) {
        String label = state.getLabel();
        if (StringUtils.isEmpty((String)label)) {
            return null;
        }
        String[] parts = label.split("%|\\\\n");
        if (parts.length == 0) {
            return null;
        }
        String name = parts[0];
        if (name.length() > 1 && name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static boolean isInsideLoop(StateflowNodeBase node) {
        HashSet<StateflowNodeBase> visited = new HashSet<StateflowNodeBase>();
        Stack<StateflowNodeBase> nodesToVisit = new Stack<StateflowNodeBase>();
        nodesToVisit.push(node);
        while (!nodesToVisit.isEmpty()) {
            StateflowNodeBase currentNode = (StateflowNodeBase)nodesToVisit.pop();
            visited.add(currentNode);
            Set reachableNodes = currentNode.getOutTransitions().stream().map(StateflowTransition::getDst).collect(Collectors.toSet());
            if (reachableNodes.contains(node)) {
                return true;
            }
            reachableNodes.removeIf(visited::contains);
            nodesToVisit.addAll(reachableNodes);
        }
        return false;
    }

    public static String getFullyQualifiedStateName(StateflowState state) {
        String name = StateflowUtils.getStateName(state);
        IStateflowNodeContainer parent = (IStateflowNodeContainer)state.getParent();
        if (parent == null) {
            return name;
        }
        if (parent instanceof StateflowChart) {
            StateflowChart chart = (StateflowChart)parent;
            return chart.getStateflowBlock().getId() + "/" + name;
        }
        return StateflowUtils.getFullyQualifiedStateName((StateflowState)parent) + "." + name;
    }

    public static boolean isHorizontalTransition(TransitionLayoutData transitionLayoutData) {
        return StateflowUtils.areOnSameLine(transitionLayoutData, Point::getY);
    }

    public static boolean isVerticalTransition(TransitionLayoutData transitionLayoutData) {
        return StateflowUtils.areOnSameLine(transitionLayoutData, Point::getX);
    }

    private static boolean areOnSameLine(TransitionLayoutData transitionLayoutData, Function<Point, Double> extractor) {
        List<Point> points = transitionLayoutData.getPoints();
        if (points.isEmpty()) {
            return true;
        }
        double val = extractor.apply(points.get(0));
        for (Point point : points) {
            if (val == extractor.apply(point)) continue;
            return false;
        }
        return true;
    }

    public static SimulinkBlock getStateflowOutport(SimulinkOutPort outPort) {
        return StateflowUtils.getStateflowPort(outPort, "Outport");
    }

    public static SimulinkBlock getStateflowInport(SimulinkInPort inPort) {
        return StateflowUtils.getStateflowPort(inPort, "Inport");
    }

    private static SimulinkBlock getStateflowPort(SimulinkPortBase port, String portType) throws AssertionError {
        CCSMAssert.isInstanceOf((Object)port.getBlock(), StateflowBlock.class);
        SimulinkBlock result = null;
        for (SimulinkBlock block : port.getBlock().getSubBlocks()) {
            if (!block.isOfType(portType) || !Objects.equals(block.getParameter("Port"), port.getIndex())) continue;
            CCSMAssert.isTrue((result == null ? 1 : 0) != 0, (String)"We assumed that there is only one matching port.");
            result = block;
        }
        return result;
    }

    public static boolean hasActionLanguageC(StateflowChart chart) {
        if (chart == null || chart.getStateflowBlock() == null) {
            return false;
        }
        if (!StateflowUtils.isStateflowChart(chart.getStateflowBlock())) {
            return false;
        }
        String actionLanguage = StateflowUtils.getTopLevelChart(chart).getParameter("actionLanguage");
        return "1".equals(actionLanguage) || actionLanguage == null;
    }

    public static boolean areCBitwiseOperationsEnabled(StateflowChart chart) {
        String actionLanguage = StateflowUtils.getTopLevelChart(chart).getParameter("actionLanguage");
        return "1".equals(actionLanguage);
    }

    @Deprecated
    public static List<StateflowTransition> getAllTransitions(StateflowChart chart) {
        return CollectionUtils.sort(StateflowUtils.getAllTransitionsAsSet(chart), Comparator.comparing(StateflowTransition::toString));
    }

    @Deprecated
    public static Set<StateflowTransition> getAllTransitionsAsSet(StateflowChart chart) {
        IdentityHashSet transitions = new IdentityHashSet(chart.getUnconnectedTransitions());
        StateflowUtils.addTransitions(chart, (Set<StateflowTransition>)transitions);
        return transitions;
    }

    @Deprecated
    private static void addTransitions(IStateflowNodeContainer<?> container, Set<StateflowTransition> transitions) {
        for (StateflowNodeBase node : container.getNodes()) {
            transitions.addAll((Collection<StateflowTransition>)node.getInTransitions());
            transitions.addAll((Collection<StateflowTransition>)node.getOutTransitions());
            if (!(node instanceof StateflowState)) continue;
            StateflowUtils.addTransitions((StateflowState)node, transitions);
        }
    }

    public static List<StateflowTransition> getAllTransitions(StateflowChart chart, boolean includeCommented) {
        return CollectionUtils.sort(StateflowUtils.getAllTransitionsAsSet(chart, includeCommented), Comparator.comparing(StateflowTransition::toString));
    }

    public static Set<StateflowTransition> getAllTransitionsAsSet(StateflowChart chart, boolean includeCommented) {
        return StateflowUtils.getAllTransitionsAsSet(chart, includeCommented, true);
    }

    public static @NonNull Set<StateflowTransition> getAllTransitionsAsSet(StateflowChart chart, boolean includeCommented, boolean includeTransitionsInSubviewers) {
        if (!includeCommented && StateflowUtils.isCommented(chart)) {
            return Collections.emptySet();
        }
        IdentityHashSet transitions = new IdentityHashSet(chart.getUnconnectedTransitions());
        StateflowUtils.addTransitions(chart, (Set<StateflowTransition>)transitions, includeCommented, includeTransitionsInSubviewers);
        return transitions;
    }

    private static void addTransitions(IStateflowNodeContainer<?> container, Set<StateflowTransition> transitions, boolean includeCommented, boolean includeTransitionsInSubviewers) {
        if (!includeCommented && container instanceof StateflowElementBase && StateflowUtils.isCommented((StateflowElementBase)((Object)container))) {
            return;
        }
        for (StateflowNodeBase node : container.getNodes()) {
            if (includeCommented) {
                transitions.addAll((Collection<StateflowTransition>)node.getInTransitions());
                transitions.addAll((Collection<StateflowTransition>)node.getOutTransitions());
            } else {
                transitions.addAll(CollectionUtils.filter(node.getInTransitions(), transition -> !StateflowUtils.isCommented(transition)));
                transitions.addAll(CollectionUtils.filter(node.getOutTransitions(), transition -> !StateflowUtils.isCommented(transition)));
            }
            if (!(node instanceof StateflowState)) continue;
            StateflowState state = (StateflowState)node;
            if (state.isSubChart() && includeTransitionsInSubviewers) {
                StateflowUtils.addTransitions(state.getSubViewer(), transitions, includeCommented, includeTransitionsInSubviewers);
                continue;
            }
            if (state.isSubChart()) continue;
            StateflowUtils.addTransitions(state, transitions, includeCommented, includeTransitionsInSubviewers);
        }
    }

    public static Optional<StateflowBlock> getNearestStateflowBlockAncestor(SimulinkBlock block) {
        for (SimulinkBlock currentBlock = block.getParent(); currentBlock != null; currentBlock = currentBlock.getParent()) {
            if (!(currentBlock instanceof StateflowBlock)) continue;
            return Optional.of((StateflowBlock)currentBlock);
        }
        return Optional.empty();
    }

    public static Optional<StateflowNodeBase> getNearestStateflowNodeAncestor(StateflowNodeBase block) {
        for (IStateflowNodeContainer currentBlock = (IStateflowNodeContainer)block.getParent(); currentBlock != null; currentBlock = (IStateflowNodeContainer)currentBlock.getParent()) {
            if (currentBlock instanceof StateflowNodeBase) {
                return Optional.of((StateflowNodeBase)((Object)currentBlock));
            }
            if (currentBlock.getParent() instanceof IStateflowNodeContainer) {
                continue;
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static boolean isMatlabFunctionBlock(SimulinkBlock block) {
        return block.isOfType("SubSystem") && "MATLAB Function".equals(block.getParameter("SFBlockType")) && block instanceof StateflowBlock;
    }

    public static List<StateflowState> getStateflowMatlabFunctions(SimulinkModel model) {
        List charts = StateflowUtils.getStateflowChartsFromModel(model, false).stream().filter(chart -> chart.getStateflowBlock() != null && chart.getStateflowBlock().isStateflowChartBlock()).collect(Collectors.toList());
        return charts.stream().map(chart -> StateflowUtils.listNodesRecursively(chart, false)).flatMap(Collection::stream).filter(node -> node instanceof StateflowState).map(node -> (StateflowState)node).filter(StateflowState::isMatlabFunction).collect(Collectors.toList());
    }

    public static List<String> extractMatlabScriptsFromBlock(SimulinkBlock block) {
        if (!StateflowUtils.isMatlabFunctionBlock(block)) {
            return Collections.emptyList();
        }
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<StateflowState> states = new ArrayList<StateflowState>();
        for (StateflowNodeBase node : ((StateflowBlock)block).getChart().getNodes()) {
            if (!(node instanceof StateflowState)) continue;
            states.add((StateflowState)node);
        }
        for (StateflowState state : states) {
            String script = StateflowUtils.extractMatlabScriptFromStateflowState(state);
            if (script == null) continue;
            scripts.add(script);
        }
        return scripts;
    }

    public static String extractMatlabScriptFromStateflowState(StateflowState state) {
        if (!state.isMatlabFunction()) {
            return null;
        }
        String script = state.getParameter("eml.script");
        if (script == null) {
            return null;
        }
        return StringUtils.unescapeChars((String)script, (Map)StringUtils.ESCAPE_NEWLINE);
    }

    public static UnmodifiableCollection<StateflowChart> getStateflowChartsFromModel(SimulinkModel model, boolean includeCommented) {
        StateflowMachine stateflowMachine = model.getStateflowMachine();
        if (stateflowMachine == null) {
            return CollectionUtils.emptyList();
        }
        return stateflowMachine.getCharts(includeCommented);
    }

    public static boolean isStateflowChart(SimulinkBlock block) {
        return block.isOfType("SubSystem") && "Chart".equals(block.getParameter("SFBlockType"));
    }

    public static List<String> extractDataNames(UnmodifiableSet<StateflowData> stateflowData) {
        ArrayList<String> parameterSymbolNames = new ArrayList<String>();
        for (StateflowData data : stateflowData) {
            if (!data.getParameterNames().contains((Object)"name")) continue;
            String parameterName = data.getParameter("name");
            parameterSymbolNames.add(parameterName);
        }
        return parameterSymbolNames;
    }

    public static Optional<String> getDataTypeOfDataName(StateflowChart chart, String dataName) {
        for (StateflowData data : chart.getData()) {
            if (!data.getParameterNames().contains((Object)"name") || !data.getParameterNames().contains((Object)"dataType")) continue;
            String parameterName = data.getParameter("name");
            String dataType = data.getParameter("dataType");
            if (!dataName.equals(parameterName)) continue;
            return Optional.ofNullable(dataType);
        }
        return Optional.empty();
    }

    public static List<StateflowBlock> listStateflowBlocksDepthFirst(SimulinkBlock block) {
        return SimulinkUtils.listBlocksDepthFirst(block, true, false).stream().filter(StateflowBlock.class::isInstance).map(StateflowBlock.class::cast).collect(Collectors.toList());
    }

    public static List<StateflowNodeBase> listNodesRecursively(StateflowChart chart, boolean includeCommented) {
        return StateflowUtils.listNodesRecursively(chart, includeCommented, true);
    }

    public static @NonNull List<StateflowNodeBase> listNodesRecursively(StateflowChart chart, boolean includeCommented, boolean includeNodesInSubviewers) {
        if (!includeCommented && StateflowUtils.isCommented(chart)) {
            return Collections.emptyList();
        }
        ArrayList<StateflowNodeBase> nodes = new ArrayList<StateflowNodeBase>();
        for (StateflowNodeBase node : chart.getNodes()) {
            nodes.addAll(StateflowUtils.listNodesRecursively(node, includeCommented, includeNodesInSubviewers));
        }
        return nodes;
    }

    public static List<StateflowNodeBase> listNodesRecursively(StateflowNodeBase node, boolean includeCommented, boolean includeNodesInSubviewers) {
        if (!includeCommented && StateflowUtils.isCommented(node)) {
            return Collections.emptyList();
        }
        ArrayList<StateflowNodeBase> nodes = new ArrayList<StateflowNodeBase>();
        nodes.add(node);
        if (!includeNodesInSubviewers && node instanceof StateflowState && ((StateflowState)node).isSubChart()) {
            return nodes;
        }
        if (!(node instanceof IStateflowNodeContainer)) {
            return nodes;
        }
        for (StateflowNodeBase childNode : ((IStateflowNodeContainer)((Object)node)).getNodes()) {
            nodes.addAll(StateflowUtils.listNodesRecursively(childNode, includeCommented, includeNodesInSubviewers));
        }
        if (node instanceof StateflowState && ((StateflowState)node).isSubChart()) {
            nodes.addAll(StateflowUtils.listNodesRecursively(((StateflowState)node).getSubViewer(), includeCommented, includeNodesInSubviewers));
        }
        return nodes;
    }

    @Deprecated
    public static List<String> extractMatlabScriptLines(StateflowState state) {
        if (StateflowUtils.isMatlabFunctionBlock(state.getParentChart().getStateflowBlock())) {
            return Collections.emptyList();
        }
        String label = state.getLabel();
        if (label == null) {
            return null;
        }
        return Arrays.stream(label.split("\\\\n")).skip(1L).filter(statement -> !statement.isEmpty()).collect(Collectors.toList());
    }

    public static List<IStateflowNodeContainer<?>> listFlowCharts(StateflowChart chart, boolean includeCommented) {
        ArrayList flowcharts = new ArrayList();
        if (StateflowUtils.isFlowChart(chart)) {
            flowcharts.add(chart);
        }
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively(chart, includeCommented)) {
            if (!(node instanceof IStateflowNodeContainer) || !StateflowUtils.isFlowChart((IStateflowNodeContainer)((Object)node))) continue;
            flowcharts.add((IStateflowNodeContainer)((Object)node));
        }
        return flowcharts;
    }

    private static boolean isFlowChart(IStateflowNodeContainer<?> container) {
        if (container.getNodes().isEmpty()) {
            return false;
        }
        boolean containsRelevantState = container.getNodes().stream().anyMatch(elementNode -> elementNode instanceof StateflowState && !((StateflowState)elementNode).isFunctionState() && !((StateflowState)elementNode).isNoteBox());
        return !containsRelevantState;
    }

    public static String extractIdFromStateflowId(String stateflowId) {
        return StringUtils.getLastPart((String)stateflowId, (char)':');
    }

    public static StateflowChart skipSubviewerParentCharts(StateflowChart chart) {
        StateflowChart parentChart = chart.getParentChart();
        while (parentChart != null && parentChart.isSubviewer()) {
            parentChart = ((IStateflowChartContainer)parentChart.getParent()).getParentChart();
        }
        return parentChart;
    }

    public static Collection<StateflowState> listStatesDepthFirst(StateflowChart chart, boolean includeCommented) {
        return StateflowUtils.listNodesRecursively(chart, includeCommented).stream().filter(StateflowState.class::isInstance).map(StateflowState.class::cast).collect(Collectors.toSet());
    }

    public static boolean isCommented(ParameterizedElement node) {
        return "1".equals(node.getParameter("comment.xplicit"));
    }

    public static @NonNull String extractStateActionsFromStateflowLabel(StateflowState state) {
        String label = state.getLabel();
        if (label == null || label.isEmpty()) {
            return "";
        }
        if (state.isNoteBox() || state.isActionSubsystemState() || state.isSimulinkFunction() || state.isGroupState() || state.isFunctionState()) {
            return "";
        }
        String unescapedLabel = StringUtils.unescapeChars((String)label, (Map)StringUtils.ESCAPE_NEWLINE);
        String stateNamePart = StateflowUtils.getStateName(state);
        CCSMAssert.isNotNull((Object)stateNamePart, () -> "Can't determine name of state " + state.getStateflowId());
        String actionCode = "";
        if (unescapedLabel.length() > stateNamePart.length()) {
            actionCode = unescapedLabel.substring(stateNamePart.length());
        }
        if (actionCode.startsWith("/")) {
            actionCode = actionCode.substring(1);
        }
        return actionCode;
    }

    public static StateflowChart getTopLevelChart(StateflowChart chart) {
        StateflowChart current = chart;
        while (!(current.getParent() instanceof StateflowMachine)) {
            current = ((IStateflowChartContainer)current.getParent()).getParentChart();
        }
        return current;
    }

    public static List<StateflowTransition> getNonCrossingTransitions(StateflowChart chart) {
        IdentityHashSet nodesOnSameLevel = new IdentityHashSet();
        if (chart.getParent() instanceof StateflowNodeBase) {
            nodesOnSameLevel.add((StateflowNodeBase)chart.getParent());
        }
        chart.getNodes().forEach(arg_0 -> StateflowUtils.lambda$getNonCrossingTransitions$9((Set)nodesOnSameLevel, arg_0));
        ArrayList<StateflowTransition> result = new ArrayList<StateflowTransition>();
        for (StateflowTransition transition : StateflowUtils.getAllTransitions(chart, true)) {
            if (transition.getSrc() != null && !nodesOnSameLevel.contains(transition.getSrc()) || transition.getDst() != null && !nodesOnSameLevel.contains(transition.getDst())) continue;
            result.add(transition);
        }
        return result;
    }

    private static /* synthetic */ void lambda$getNonCrossingTransitions$9(Set nodesOnSameLevel, StateflowNodeBase node) {
        nodesOnSameLevel.addAll(StateflowUtils.listNodesRecursively(node, true, false));
    }
}

