/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util.geometry;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PathBezierApproximationHelper {
    private final int numApproximationSegmentsPerBezierCurve;
    private double[][] bezierQuadFactors;
    private double[][] bezierCubicFactors;

    public PathBezierApproximationHelper(int numApproximationSegmentsPerBezierCurve) {
        this.numApproximationSegmentsPerBezierCurve = numApproximationSegmentsPerBezierCurve;
    }

    public @Nullable GeneralPath buildStraightSegments(@Nullable GeneralPath path) {
        if (path == null) {
            return null;
        }
        GeneralPath segments = new GeneralPath();
        double[] coords = new double[6];
        PathIterator pathIterator = path.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    segments.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    segments.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.appendSegmentsForQuadBezierCurve(segments.getCurrentPoint(), coords, segments);
                    break;
                }
                case 3: {
                    this.appendSegmentsForCubicBezierCurve(segments.getCurrentPoint(), coords, segments);
                    break;
                }
                case 4: {
                    segments.closePath();
                }
            }
            pathIterator.next();
        }
        return segments;
    }

    private void initQuadFactors() {
        this.bezierQuadFactors = new double[this.numApproximationSegmentsPerBezierCurve][3];
        for (int i = 1; i < this.numApproximationSegmentsPerBezierCurve; ++i) {
            double t = (double)i / (double)(this.numApproximationSegmentsPerBezierCurve - 1);
            double f0 = (1.0 - t) * (1.0 - t);
            double f1 = 2.0 * (1.0 - t) * t;
            double f2 = t * t;
            this.bezierQuadFactors[i][0] = f0;
            this.bezierQuadFactors[i][1] = f1;
            this.bezierQuadFactors[i][2] = f2;
        }
    }

    private void appendSegmentsForQuadBezierCurve(Point2D bezierPoint0, double[] coords, GeneralPath resultPath) {
        if (this.bezierQuadFactors == null) {
            this.initQuadFactors();
        }
        double b0X = bezierPoint0.getX();
        double b0Y = bezierPoint0.getY();
        double b1X = coords[0];
        double b1Y = coords[1];
        double b2X = coords[2];
        double b2Y = coords[3];
        for (int i = 1; i < this.numApproximationSegmentsPerBezierCurve; ++i) {
            double f0 = this.bezierQuadFactors[i][0];
            double f1 = this.bezierQuadFactors[i][1];
            double f2 = this.bezierQuadFactors[i][2];
            double x = f0 * b0X + f1 * b1X + f2 * b2X;
            double y = f0 * b0Y + f1 * b1Y + f2 * b2Y;
            resultPath.lineTo(x, y);
        }
    }

    private void initCubicFactors() {
        this.bezierCubicFactors = new double[this.numApproximationSegmentsPerBezierCurve][4];
        for (int i = 1; i < this.numApproximationSegmentsPerBezierCurve; ++i) {
            double t = (double)i / (double)(this.numApproximationSegmentsPerBezierCurve - 1);
            double f0 = (1.0 - t) * (1.0 - t) * (1.0 - t);
            double f1 = 3.0 * (1.0 - t) * (1.0 - t) * t;
            double f2 = 3.0 * (1.0 - t) * t * t;
            double f3 = t * t * t;
            this.bezierCubicFactors[i][0] = f0;
            this.bezierCubicFactors[i][1] = f1;
            this.bezierCubicFactors[i][2] = f2;
            this.bezierCubicFactors[i][3] = f3;
        }
    }

    private void appendSegmentsForCubicBezierCurve(Point2D bezierPoint0, double[] coords, GeneralPath resultPath) {
        if (this.bezierCubicFactors == null) {
            this.initCubicFactors();
        }
        double b0X = bezierPoint0.getX();
        double b0Y = bezierPoint0.getY();
        double b1X = coords[0];
        double b1Y = coords[1];
        double b2X = coords[2];
        double b2Y = coords[3];
        double b3X = coords[4];
        double b3Y = coords[5];
        for (int i = 1; i < this.numApproximationSegmentsPerBezierCurve; ++i) {
            double f0 = this.bezierCubicFactors[i][0];
            double f1 = this.bezierCubicFactors[i][1];
            double f2 = this.bezierCubicFactors[i][2];
            double f3 = this.bezierCubicFactors[i][3];
            double x = f0 * b0X + f1 * b1X + f2 * b2X + f3 * b3X;
            double y = f0 * b0Y + f1 * b1Y + f2 * b2Y + f3 * b3Y;
            resultPath.lineTo(x, y);
        }
    }
}

