/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.resources;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationIndex;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationMetadata;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationOptions;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonExternalSnapshotIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotDto;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotMetaData;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorBase;
import com.teamscale.index.admin.instance_import.InstanceCredentials;
import com.teamscale.service.admin.instance_comparison.InstanceComparisonService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.ui.ETeamscalePerspective;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;

@Path(value="api/instance-comparison/redirect")
public class InstanceComparisonRedirectionService
extends ApiBase {
    private static final NavigableMap<Version, IRedirectionUriFactory> URI_FACTORY_FOR_VERSION = InstanceComparisonRedirectionService.buildUriFactoryForVersionMap();
    private static final ConcurrentHashMap<String, InstanceInformation> CACHED_INSTANCE_INFORMATION = new ConcurrentHashMap();

    private static NavigableMap<Version, IRedirectionUriFactory> buildUriFactoryForVersionMap() {
        TreeMap<Version, IRedirectionUriFactory> tmp = new TreeMap<Version, IRedirectionUriFactory>();
        tmp.put(ETeamscaleVersion.VERSION_7_6_0.toVersionObject(), InstanceComparisonRedirectionService::getUriForVersion760);
        tmp.put(ETeamscaleVersion.VERSION_9_1_0.toVersionObject(), InstanceComparisonRedirectionService::getUriForVersion910);
        return Collections.unmodifiableNavigableMap(tmp);
    }

    @Operation(summary="Redirect to the example hosting host", description="Redirects to /example on the instance, which hosts the actual example.", tags={"Instance Comparison"})
    @ApiResponses(value={@ApiResponse(responseCode="307", description="Redirects to the /example endpoint"), @ApiResponse(responseCode="404", description="No comparison found for \"comparison-id\"")})
    @GET
    @RequiresNoPermission
    public Response redirectToCorrectHost(@QueryParam(value="snapshot-id") @Parameter(description="Id of the snapshot the comparison belongs to") @NonNull String snapshotId, @QueryParam(value="comparison-id") @Parameter(description="Id of the comparison the example belongs to") @NonNull String comparisonId, @QueryParam(value="project") @Parameter(description="Project ID of the example") @NonNull PublicProjectId project, @QueryParam(value="example-id") @Parameter(description="ID of the example") @NonNull String exampleId, @QueryParam(value="example-type") @Parameter(description="Type of the example") // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull DetailedInstanceComparisonValue.EInstanceComparisonType exampleType, @QueryParam(value="is-remote-example") @Parameter(description="Whether the example is on the remote instance") boolean remote) throws StorageException {
        URI redirectUri;
        String key = this.makeKey(snapshotId, comparisonId);
        InstanceInformation instanceInformation = (InstanceInformation)CollectionUtils.computeIfAbsentWithException(CACHED_INSTANCE_INFORMATION, (Object)key, v -> this.buildInstanceInformation(snapshotId, comparisonId));
        RedirectionInformation redirectionInformation = this.buildRedirectionInformation(instanceInformation, project, exampleId, exampleType);
        if (remote) {
            Version remoteInstanceTeamscaleVersion = instanceInformation.remoteVersion;
            CCSMAssert.isNotNull((Object)remoteInstanceTeamscaleVersion, () -> String.format("Expected \"%s\" to be not null", "remoteInstanceTeamscaleVersion"));
            redirectUri = this.getUriForVersion(remoteInstanceTeamscaleVersion, redirectionInformation, true);
        } else {
            redirectUri = this.getUriForVersion(ETeamscaleVersion.CURRENT_VERSION.toVersionObject(), redirectionInformation, false);
        }
        return Response.temporaryRedirect((URI)redirectUri).build();
    }

    private String makeKey(String snapshotId, String comparisonId) {
        return snapshotId + "#" + comparisonId;
    }

    private InstanceInformation buildInstanceInformation(String snapshotId, String comparisonId) throws StorageException {
        InstanceComparisonComputationMetadata comparison;
        try {
            comparison = this.getComparison(snapshotId, comparisonId);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        InstanceComparisonComputationOptions comparisonOptions = comparison.getOptions();
        RedirectionInstanceParameter instanceParameter = this.buildInstanceParameter(false, comparisonOptions);
        RedirectionInstanceParameter oppositeParameter = this.buildInstanceParameter(true, comparisonOptions);
        UriBuilder uriBuilder = this.getBaseUriBuilder(false, comparisonOptions).orElseThrow(() -> new AssertionError((Object)"Local URI must always be present"));
        UriBuilder remoteUriBuilder = this.getBaseUriBuilder(true, comparisonOptions).orElse(null);
        Version version = comparison.getRemoteInstanceTeamscaleVersion();
        return new InstanceInformation(instanceParameter, oppositeParameter, version, uriBuilder, remoteUriBuilder);
    }

    private RedirectionInformation buildRedirectionInformation(InstanceInformation instanceInformation, PublicProjectId project, String exampleId, DetailedInstanceComparisonValue.EInstanceComparisonType exampleType) {
        RedirectionExampleParameter exampleInformation = this.buildInstanceRedirectInformation(project, exampleId, exampleType);
        return new RedirectionInformation(instanceInformation, exampleInformation);
    }

    private RedirectionInstanceParameter buildInstanceParameter(boolean remote, InstanceComparisonComputationOptions comparisonOptions) throws StorageException {
        Optional<String> optionalUser = InstanceComparisonRedirectionService.getSnapshotUser(remote, comparisonOptions);
        if (optionalUser.isPresent()) {
            return new RedirectionInstanceParameter(this.getSnapshotId(remote, comparisonOptions), optionalUser.get());
        }
        return null;
    }

    private RedirectionExampleParameter buildInstanceRedirectInformation(PublicProjectId project, String exampleId, DetailedInstanceComparisonValue.EInstanceComparisonType exampleType) {
        return new RedirectionExampleParameter(project, exampleId, exampleType);
    }

    private URI getUriForVersion(Version targetTeamscaleVersion, RedirectionInformation redirectionInformation, boolean remote) throws StorageException {
        return URI_FACTORY_FOR_VERSION.floorEntry(targetTeamscaleVersion).getValue().buildRedirectionUri(this, redirectionInformation, remote);
    }

    private URI getUriForVersion760(RedirectionInformation redirectionInformation, boolean remote) throws StorageException {
        if (redirectionInformation.exampleInformation().exampleType == DetailedInstanceComparisonValue.EInstanceComparisonType.FINDING_LIST) {
            return redirectionInformation.instanceInformation().remoteUriBuilder().build(new Object[0]).resolve(this.getFindingListRedirectionUri(redirectionInformation.instanceInformation().instanceParameter(), redirectionInformation.exampleInformation()));
        }
        return this.getUriForVersion910(redirectionInformation, remote);
    }

    private URI getUriForVersion910(RedirectionInformation redirectionInformation, boolean remote) {
        RedirectionInstanceParameter instanceParameter;
        UriBuilder root;
        if (remote) {
            root = redirectionInformation.instanceInformation().remoteUriBuilder();
            instanceParameter = redirectionInformation.instanceInformation().remoteInstanceParameter();
        } else {
            root = redirectionInformation.instanceInformation().uriBuilder();
            instanceParameter = redirectionInformation.instanceInformation().instanceParameter();
        }
        RedirectionExampleParameter redirectionParameter = redirectionInformation.exampleInformation();
        root.path("instance-comparison/redirect/example");
        root.queryParam("snapshot-id", new Object[]{"{snapshotId}"}).queryParam("example-id", new Object[]{"{exampleId}"}).queryParam("example-type", new Object[]{"{exampleType}"}).queryParam("project", new Object[]{"{project}"}).queryParam("snapshot-user", new Object[]{"{snapshotUser}"});
        return root.build(new Object[]{instanceParameter.snapshotId(), redirectionParameter.getExampleId(), redirectionParameter.getExampleType(), redirectionParameter.getProject(), instanceParameter.snapshotUser()});
    }

    private InstanceComparisonComputationMetadata getComparison(String snapshotId, String comparisonId) throws StorageException {
        InstanceComparisonComputationIndex comparisonIndex = (InstanceComparisonComputationIndex)this.openGlobalIndex(InstanceComparisonComputationIndex.class);
        return InstanceComparisonService.getComparisonComputation((String)snapshotId, (String)comparisonId, (InstanceComparisonComputationIndex)comparisonIndex);
    }

    private String getSnapshotId(boolean remote, InstanceComparisonComputationOptions comparisonOptions) throws StorageException {
        if (remote) {
            if (comparisonOptions.isExternallyUploadedSnapshot()) {
                InstanceComparisonExternalSnapshotIndex externalSnapshotIndex = (InstanceComparisonExternalSnapshotIndex)this.openGlobalIndex(InstanceComparisonExternalSnapshotIndex.class);
                return ((InstanceComparisonSnapshotDto)externalSnapshotIndex.getSnapshot(comparisonOptions.getRemoteSnapshotId()).orElseThrow(() -> new IllegalStateException("Snapshot not found for the given id"))).id();
            }
            return comparisonOptions.getRemoteSnapshotId();
        }
        return comparisonOptions.getLocalSnapshotId();
    }

    private static Optional<String> getSnapshotUser(boolean remote, InstanceComparisonComputationOptions comparisonOptions) {
        if (remote) {
            return comparisonOptions.getRemoteInstanceCredentials().map(InstanceCredentials::getUsername);
        }
        return Optional.of(comparisonOptions.getUsername());
    }

    private Optional<UriBuilder> getBaseUriBuilder(boolean remote, InstanceComparisonComputationOptions comparisonOptions) {
        Optional<UriBuilder> result = remote ? comparisonOptions.getRemoteInstanceCredentials().map(InstanceCredentials::getTeamscaleUrl).map(UriBuilder::fromUri) : Optional.of(UriBuilder.fromUri((URI)this.createRedirectUri("")));
        return result.map(uri -> uri.path("api"));
    }

    @Path(value="example")
    @GET
    @RequiresNoLogin(description="login and permissions will be checked at redirection target")
    @PublicApi(since=ETeamscaleVersion.VERSION_7_6_0)
    @Hidden
    public Response redirectToExample(@BeanParam RedirectionInstanceParameter instanceParameter, @BeanParam RedirectionExampleParameter redirectionParameter) throws StorageException {
        URI redirectionUri = switch (redirectionParameter.getExampleType()) {
            default -> throw new MatchException(null, null);
            case DetailedInstanceComparisonValue.EInstanceComparisonType.FINDING -> this.getFindingRedirectionUri(instanceParameter, redirectionParameter);
            case DetailedInstanceComparisonValue.EInstanceComparisonType.PARSE_LOG_ERROR -> InstanceComparisonRedirectionService.getParserLogRedirectionUri(redirectionParameter);
            case DetailedInstanceComparisonValue.EInstanceComparisonType.MAINTENANCE_LOG_ERROR, DetailedInstanceComparisonValue.EInstanceComparisonType.WORKER_LOG_ERROR -> InstanceComparisonRedirectionService.getWorkerLogRedirectionUri(redirectionParameter);
            case DetailedInstanceComparisonValue.EInstanceComparisonType.METHOD_COVERAGE -> InstanceComparisonRedirectionService.getCoveredMethodRedirectionUri(redirectionParameter);
            case DetailedInstanceComparisonValue.EInstanceComparisonType.USER -> InstanceComparisonRedirectionService.getUserRedirectionUri(redirectionParameter);
            case DetailedInstanceComparisonValue.EInstanceComparisonType.GROUP -> InstanceComparisonRedirectionService.getGroupRedirectionUri(redirectionParameter);
            case DetailedInstanceComparisonValue.EInstanceComparisonType.FINDING_LIST -> this.getFindingListRedirectionUri(instanceParameter, redirectionParameter);
        };
        return Response.temporaryRedirect((URI)this.createRedirectUri(redirectionUri.toString())).build();
    }

    private static URI getGroupRedirectionUri(RedirectionExampleParameter redirectionParameter) {
        String groupName = redirectionParameter.getExampleId();
        return ETeamscalePerspective.ADMIN.createUri("groups").queryParam("action", new Object[]{"edit"}).queryParam("groupId", new Object[]{groupName}).build(new Object[0]);
    }

    private static URI getUserRedirectionUri(RedirectionExampleParameter redirectionParameter) {
        String userName = redirectionParameter.getExampleId();
        return ETeamscalePerspective.ADMIN.createUri("users").queryParam("action", new Object[]{"edit"}).queryParam("username", new Object[]{userName}).build(new Object[0]);
    }

    private URI getFindingRedirectionUri(RedirectionInstanceParameter instanceParameter, RedirectionExampleParameter redirectionParameter) throws StorageException {
        InstanceComparisonSnapshotMetaData snapshot = this.getSnapshot(instanceParameter);
        PublicProjectId project = redirectionParameter.getProject();
        String branchName = this.determineBranchName(snapshot, project);
        return ETeamscalePerspective.FINDINGS.createUri("details", project).queryParam("id", new Object[]{"{id}"}).queryParam("t", new Object[]{"{commit}"}).build(new Object[]{redirectionParameter.getExampleId(), new UnresolvedCommitDescriptor(branchName, snapshot.getOptions().getEndTimestamp())});
    }

    private URI getFindingListRedirectionUri(RedirectionInstanceParameter instanceParameter, RedirectionExampleParameter redirectionParameter) throws StorageException {
        InstanceComparisonSnapshotMetaData snapshot = this.getSnapshot(instanceParameter);
        PublicProjectId project = redirectionParameter.getProject();
        String branchName = this.determineBranchName(snapshot, project);
        long timestamp = snapshot.getOptions().getEndTimestamp();
        String checkName = StringUtils.getLastPart((String)redirectionParameter.getExampleId(), (String)"/", (int)2);
        return ETeamscalePerspective.FINDINGS.createUri("list", project).queryParam("filter", new Object[]{"{filter}"}).queryParam("invert", new Object[]{true}).queryParam("t", new Object[]{"{commit}"}).build(new Object[]{checkName, new UnresolvedCommitDescriptor(branchName, timestamp)});
    }

    private String determineBranchName(InstanceComparisonSnapshotMetaData snapshot, PublicProjectId project) throws StorageException {
        String branchName = snapshot.getOptions().getBranchName();
        if (branchName == null || ProjectComparisonContributorBase.branchNotExistsInProject((ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)project), (String)branchName)) {
            branchName = this.getDefaultBranchName((IProjectId)project);
        }
        return branchName;
    }

    private static URI getParserLogRedirectionUri(RedirectionExampleParameter redirectionParameter) {
        DetailedInstanceComparisonValue.ParserLogId logId = InstanceComparisonRedirectionService.deserializeExampleId(redirectionParameter.getExampleId(), DetailedInstanceComparisonValue.ParserLogId.class);
        return ETeamscalePerspective.METRICS.createUri("code", redirectionParameter.getProject(), logId.getUniformPath()).queryParam("t", new Object[]{logId.getCommit().toServiceCallFormat()}).queryParam("selection", new Object[]{String.format("%1$d-%1$d", logId.getLineNumber())}).build(new Object[0]);
    }

    private static URI getWorkerLogRedirectionUri(RedirectionExampleParameter redirectionParameter) {
        DetailedInstanceComparisonValue.WorkerLogId workerLogId = InstanceComparisonRedirectionService.deserializeExampleId(redirectionParameter.getExampleId(), DetailedInstanceComparisonValue.WorkerLogId.class);
        PublicProjectId project = redirectionParameter.getProject();
        return ETeamscalePerspective.SYSTEM.createUri("worker-log").queryParam("project", new Object[]{"{project}"}).queryParam("entry-timestamp", new Object[]{"{timestamp}"}).build(new Object[]{project, workerLogId.getTimestamp()});
    }

    private static URI getCoveredMethodRedirectionUri(RedirectionExampleParameter redirectionParameter) {
        DetailedInstanceComparisonValue.MethodReference methodReference = InstanceComparisonRedirectionService.deserializeExampleId(redirectionParameter.getExampleId(), DetailedInstanceComparisonValue.MethodReference.class);
        return ETeamscalePerspective.ACTIVITY.createUri("method-history", redirectionParameter.getProject(), methodReference.getMethodLocation().getUniformPath()).queryParam("startOffset", new Object[]{methodReference.getMethodLocation().getRegion().getStart()}).queryParam("endOffset", new Object[]{methodReference.getMethodLocation().getRegion().getEnd()}).queryParam("t", new Object[]{methodReference.getCommit().toServiceCallFormat()}).queryParam("partitions", new Object[]{"all"}).build(new Object[0]);
    }

    private InstanceComparisonSnapshotMetaData getSnapshot(RedirectionInstanceParameter redirectionParameter) throws StorageException {
        String snapshotUser = redirectionParameter.snapshotUser();
        return InstanceComparisonService.getSnapshotForPrefix((String)redirectionParameter.snapshotId(), (String)snapshotUser, (InstanceComparisonSnapshotCreationIndex)((InstanceComparisonSnapshotCreationIndex)this.openGlobalIndex(InstanceComparisonSnapshotCreationIndex.class)));
    }

    private static <T> T deserializeExampleId(String exampleId, Class<T> idClass) {
        try {
            return (T)JsonUtils.deserializeFromJson((String)exampleId, idClass);
        }
        catch (JsonSerializationException e) {
            throw new BadRequestException(String.format("Could not parse example id \"%s\"", exampleId), (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface IRedirectionUriFactory {
        public URI buildRedirectionUri(InstanceComparisonRedirectionService var1, RedirectionInformation var2, boolean var3) throws StorageException;
    }

    private record InstanceInformation(RedirectionInstanceParameter instanceParameter, @Nullable RedirectionInstanceParameter remoteInstanceParameter, Version remoteVersion, UriBuilder uriBuilder, @Nullable UriBuilder remoteUriBuilder) {
        private final @Nullable RedirectionInstanceParameter remoteInstanceParameter;
        private final UriBuilder uriBuilder;
        private final @Nullable UriBuilder remoteUriBuilder;

        public UriBuilder uriBuilder() {
            return this.uriBuilder.clone();
        }

        public UriBuilder remoteUriBuilder() {
            return InstanceInformation.verifyRemoteDataExistence(this.remoteUriBuilder).clone();
        }

        public RedirectionInstanceParameter remoteInstanceParameter() {
            return InstanceInformation.verifyRemoteDataExistence(this.remoteInstanceParameter);
        }

        private static <T> T verifyRemoteDataExistence(@Nullable T parameter) {
            if (parameter == null) {
                throw new BadRequestException("Can't redirect to a remote instance if URL is unknown");
            }
            return parameter;
        }
    }

    private record RedirectionInformation(InstanceInformation instanceInformation, RedirectionExampleParameter exampleInformation) {
    }

    public record RedirectionInstanceParameter(@NonNull String snapshotId, @NonNull String snapshotUser) {
        private static final String SNAPSHOT_ID_PARAMETER = "snapshot-id";
        private static final String SNAPSHOT_USER_PARAMETER = "snapshot-user";

        public RedirectionInstanceParameter(@QueryParam(value="snapshot-id") @NonNull String snapshotId, @QueryParam(value="snapshot-user") @NonNull String snapshotUser) {
            CCSMAssert.isNotNull((Object)snapshotId, () -> String.format("Expected \"%s\" to be not null", SNAPSHOT_ID_PARAMETER));
            CCSMAssert.isNotNull((Object)snapshotUser, () -> String.format("Expected \"%s\" to be not null", SNAPSHOT_USER_PARAMETER));
        }
    }

    public static class RedirectionExampleParameter {
        private static final String PROJECT_PARAMETER = "project";
        private static final String EXAMPLE_ID_PARAMETER = "example-id";
        private static final String EXAMPLE_TYPE_PARAMETER = "example-type";
        private final @NonNull PublicProjectId project;
        private final @NonNull String exampleId;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull DetailedInstanceComparisonValue.EInstanceComparisonType exampleType;

        public RedirectionExampleParameter(@QueryParam(value="project") @NonNull PublicProjectId project, @QueryParam(value="example-id") @NonNull String exampleId, @QueryParam(value="example-type") // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull DetailedInstanceComparisonValue.EInstanceComparisonType exampleType) {
            CCSMAssert.isNotNull((Object)project, () -> String.format("Expected \"%s\" to be not null", PROJECT_PARAMETER));
            CCSMAssert.isNotNull((Object)exampleId, () -> String.format("Expected \"%s\" to be not null", EXAMPLE_ID_PARAMETER));
            CCSMAssert.isNotNull((Object)exampleType, () -> String.format("Expected \"%s\" to be not null", EXAMPLE_TYPE_PARAMETER));
            this.exampleId = exampleId;
            this.project = project;
            this.exampleType = exampleType;
        }

        public @NonNull PublicProjectId getProject() {
            return this.project;
        }

        public @NonNull String getExampleId() {
            return this.exampleId;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull DetailedInstanceComparisonValue.EInstanceComparisonType getExampleType() {
            return this.exampleType;
        }
    }
}

