/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.badge;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public class SvgUtils {
    private static final List<String> DESIRED_FONTS = Arrays.asList("DejaVu Sans", "Verdana", "Geneva");

    public static int computeTextWidth(String text) {
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        Rectangle2D textRectangle = SvgUtils.determineFont().getStringBounds(text, fontRenderContext);
        return (int)Math.ceil(textRectangle.getWidth());
    }

    public static Font determineFont() {
        HashSet availableFontNames = CollectionUtils.asHashSet((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        for (String desiredFontName : DESIRED_FONTS) {
            if (!availableFontNames.contains(desiredFontName)) continue;
            return new Font(desiredFontName, 0, 12);
        }
        return new Font("SansSerif", 0, 12);
    }
}

