/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.versioning;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

public class VersionedMediaTypeUtils {
    public static final Set<Class<?>> PRIMITIVE_TYPES = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class));
    public static final List<MediaType> DEFAULT_CONSUMED_MEDIA_TYPES = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    public static final List<MediaType> DEFAULT_PRIMITIVE_CONSUMED_MEDIA_TYPES = Arrays.asList(MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_JSON_TYPE);
    private static final List<MediaType> DEFAULT_PRODUCED_MEDIA_TYPES = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    private static final List<MediaType> DEFAULT_PRODUCED_PRIMITIVE_MEDIA_TYPES = Arrays.asList(MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_JSON_TYPE);

    public static boolean isApplicableForSubtype(MediaType mediaType, String subtype) {
        return mediaType.getSubtype().equals(subtype) || mediaType.getSubtype().endsWith("+" + subtype);
    }

    public static Set<MediaType> convertToVersionedMediaTypes(Collection<MediaType> mediaTypes, ETeamscaleVersion version) {
        LinkedHashSet<MediaType> versionedMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType consumedType : mediaTypes) {
            versionedMediaTypes.add(VersionedMediaTypeUtils.convertToVersionedMediaType(consumedType, version));
        }
        return versionedMediaTypes;
    }

    private static MediaType convertToVersionedMediaType(MediaType mediaType, ETeamscaleVersion version) {
        if (mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
            return mediaType;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("q", "0.1");
        parameters.put("qs", "0.1");
        parameters.putAll(mediaType.getParameters());
        String subtype = "vnd.teamscale.v" + String.valueOf(version) + "+" + mediaType.getSubtype();
        return new MediaType(mediaType.getType(), subtype, parameters);
    }

    public static MediaType convertToNonVersionedMediaType(MediaType mediaType) {
        if (mediaType.getSubtype().startsWith("vnd.teamscale.v")) {
            String subtype = StringUtils.getLastPart((String)mediaType.getSubtype(), (String)"+");
            return new MediaType(mediaType.getType(), subtype);
        }
        return mediaType;
    }

    private static Class<?> methodRequestBodyType(Method definitionMethod) {
        Annotation[][] parameterAnnotations = definitionMethod.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof RequestBody)) continue;
                return definitionMethod.getParameterTypes()[i];
            }
        }
        return null;
    }

    public static List<MediaType> getDefaultProducedMediaTypes(Method method) {
        if (LegacyApiUtils.isLegacyApi(method) && method.getReturnType().isAssignableFrom(Response.class)) {
            return DEFAULT_PRODUCED_PRIMITIVE_MEDIA_TYPES;
        }
        Optional<PublicApi> publicApiAnnotation = ServiceAnnotationUtils.getMethodAnnotation(PublicApi.class, method);
        if (publicApiAnnotation.isEmpty() || !ServiceAnnotationUtils.isDeprecated(publicApiAnnotation.get())) {
            return VersionedMediaTypeUtils.getInferredProducedTypesFromReturnType(method);
        }
        return List.of();
    }

    public static List<MediaType> getDefaultConsumedMediaTypes(Method method) {
        Class<?> bodyType = VersionedMediaTypeUtils.methodRequestBodyType(method);
        if (bodyType == null) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        if (VersionedMediaTypeUtils.convertsToPrimitiveType(bodyType)) {
            return DEFAULT_PRIMITIVE_CONSUMED_MEDIA_TYPES;
        }
        return DEFAULT_CONSUMED_MEDIA_TYPES;
    }

    public static List<MediaType> getInferredProducedTypesFromReturnType(Method method) {
        if (VersionedMediaTypeUtils.convertsToPrimitiveType(method.getReturnType())) {
            return DEFAULT_PRODUCED_PRIMITIVE_MEDIA_TYPES;
        }
        if (method.getReturnType() == Void.TYPE) {
            return Collections.emptyList();
        }
        return DEFAULT_PRODUCED_MEDIA_TYPES;
    }

    private static boolean convertsToPrimitiveType(Class<?> bodyType) {
        return PRIMITIVE_TYPES.contains(bodyType) || Enum.class.isAssignableFrom(bodyType);
    }
}

