/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class TaskWrappingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;
    private final Wrapper taskWrapper;

    public TaskWrappingExecutorService(ExecutorService delegate, Wrapper taskWrapper) {
        CCSMAssert.isNotNull((Object)delegate, () -> String.format("Expected \"%s\" to be not null", "delegate"));
        CCSMAssert.isNotNull((Object)taskWrapper, () -> String.format("Expected \"%s\" to be not null", "taskWrapper"));
        this.delegate = delegate;
        this.taskWrapper = taskWrapper;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public @NonNull List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow().stream().map(this.taskWrapper::unwrap).collect(Collectors.toList());
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> @NonNull Future<T> submit(@NonNull Callable<T> task) {
        return this.delegate.submit(this.taskWrapper.wrap(task));
    }

    @Override
    public <T> @NonNull Future<T> submit(@NonNull Runnable task, T result) {
        return this.delegate.submit(this.taskWrapper.wrap(task), result);
    }

    @Override
    public @NonNull Future<?> submit(@NonNull Runnable task) {
        return this.delegate.submit(this.taskWrapper.wrap(task));
    }

    @Override
    public <T> @NonNull List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrap(tasks));
    }

    @Override
    public <T> @NonNull List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    public <T> @NonNull T invokeAny(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrap(tasks), timeout, unit);
    }

    private <T> @NonNull List<Callable<T>> wrap(@NonNull Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this.taskWrapper::wrap).collect(Collectors.toList());
    }

    @Override
    public void execute(@NonNull Runnable command) {
        this.delegate.execute(this.taskWrapper.wrap(command));
    }

    public static interface Wrapper {
        public <T> @NonNull Callable<T> wrap(@NonNull Callable<T> var1);

        public <T> @NonNull Callable<T> unwrap(@NonNull Callable<T> var1);

        public @NonNull Runnable wrap(@NonNull Runnable var1);

        public @NonNull Runnable unwrap(@NonNull Runnable var1);
    }
}

