/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.date;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.VisibleForTesting;

public class DateTimeUtils {
    static final String NOW_SYSTEM_PROPERTY_NAME = "org.conqat.lib.commons.date.now";
    static final String NOW_SYSTEM_PROPERTY_PATTERN = "yyyyMMddHHmmss";
    private static final ClockProvider CLOCK_PROVIDER = new ClockProvider();
    public static final DateTimeFormatter UI_FORMATTER = DateTimeUtils.createDateTimeFormatter("MMM dd yyyy HH:mm");

    public static Clock getClock() {
        return CLOCK_PROVIDER.getClock();
    }

    public static ZoneId getZone() {
        return DateTimeUtils.getClock().getZone();
    }

    public static Instant now() {
        return DateTimeUtils.withClock(Clock::instant);
    }

    public static long millisNow() {
        return DateTimeUtils.getClock().millis();
    }

    public static ZonedDateTime zonedNow() {
        return DateTimeUtils.withClock(ZonedDateTime::now);
    }

    public static <T extends Temporal> T withClock(Function<Clock, T> creator) {
        return (T)((Temporal)creator.apply(DateTimeUtils.getClock()));
    }

    public static ZonedDateTime atZone(Instant instant) {
        return instant.atZone(DateTimeUtils.getZone());
    }

    public static ZonedDateTime atZone(long timestamp) {
        return DateTimeUtils.atZone(Instant.ofEpochMilli(timestamp));
    }

    public static long diff(Instant start, Instant end, TimeUnit timeUnit) {
        CCSMAssert.isNotNull((Object)start, () -> String.format("Expected \"%s\" to be not null", "start"));
        CCSMAssert.isNotNull((Object)end, () -> String.format("Expected \"%s\" to be not null", "end"));
        CCSMAssert.isNotNull((Object)timeUnit, () -> String.format("Expected \"%s\" to be not null", "timeUnit"));
        long millis = Duration.between(start, end).toMillis();
        return timeUnit.convert(millis, TimeUnit.MILLISECONDS);
    }

    public static DateTimeFormatter createDateTimeFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
    }

    public static String getUiFormattedDateString(long timestamp) {
        return DateTimeUtils.formatTimestamp(timestamp, UI_FORMATTER);
    }

    public static String getUiFormattedDateStringWithSeconds(long timestamp) {
        return DateTimeUtils.formatTimestamp(timestamp, DateTimeUtils.createDateTimeFormatter("MMM dd yyyy HH:mm:ss"));
    }

    public static String formatTimestamp(long timestamp, DateTimeFormatter formatter) {
        CCSMAssert.isNotNull((Object)formatter, () -> String.format("Expected \"%s\" to be not null", "formatter"));
        return DateTimeUtils.atZone(timestamp).format(formatter);
    }

    @VisibleForTesting
    public static void setClock(Clock clock) {
        CCSMAssert.isNotNull((Object)clock, () -> String.format("Expected \"%s\" to be not null", "clock"));
        CLOCK_PROVIDER.setClock(clock);
    }

    @VisibleForTesting
    public static void setZone(ZoneId zone) {
        CCSMAssert.isNotNull((Object)zone, () -> String.format("Expected \"%s\" to be not null", "zone"));
        CLOCK_PROVIDER.updateClock(clock -> clock.withZone(zone));
    }

    @VisibleForTesting
    public static void setFixedClock(Instant fixed) {
        CCSMAssert.isNotNull((Object)fixed, () -> String.format("Expected \"%s\" to be not null", "fixed"));
        CLOCK_PROVIDER.updateClock(clock -> Clock.fixed(fixed, clock.getZone()));
    }

    @VisibleForTesting
    public static void setFixedClock(LocalDate date) {
        DateTimeUtils.setFixedClock(date.atStartOfDay());
    }

    @VisibleForTesting
    public static void setFixedClock(LocalDateTime dateTime) {
        DateTimeUtils.setFixedClock(dateTime.atZone(DateTimeUtils.getZone()).toInstant());
    }

    @VisibleForTesting
    public static void setFixedClock(OffsetDateTime dateTime) {
        DateTimeUtils.setClock(Clock.fixed(dateTime.toInstant(), dateTime.getOffset()));
    }

    @VisibleForTesting
    public static void setFixedClock(ZonedDateTime dateTime) {
        DateTimeUtils.setClock(Clock.fixed(dateTime.toInstant(), dateTime.getZone()));
    }

    @VisibleForTesting
    public static void resetClock() {
        CLOCK_PROVIDER.resetClock();
    }

    public static boolean hasDurationPassedSince(LocalDateTime dateTimeToCompare, Duration durationBeforeNow) {
        return dateTimeToCompare.isBefore(LocalDateTime.ofInstant(DateTimeUtils.now(), DateTimeUtils.getZone()).minus(durationBeforeNow));
    }

    private static class ClockProvider {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        private final StampedLock lock = new StampedLock();
        private Clock clock;

        private ClockProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Clock getClock() {
            long stamp = this.lock.readLock();
            try {
                while (this.clock == null) {
                    long tmpStamp = this.lock.tryConvertToWriteLock(stamp);
                    if (tmpStamp != 0L) {
                        stamp = tmpStamp;
                        this.clock = ClockProvider.resolveClock();
                        break;
                    }
                    this.lock.unlockRead(stamp);
                    stamp = this.lock.writeLock();
                }
                Clock clock = this.clock;
                return clock;
            }
            finally {
                this.lock.unlock(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setClock(Clock clock) {
            long stamp = this.lock.writeLock();
            try {
                this.clock = clock;
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }

        public void resetClock() {
            this.setClock(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateClock(UnaryOperator<Clock> operator) {
            CCSMAssert.isNotNull(operator, () -> String.format("Expected \"%s\" to be not null", "operator"));
            long stamp = this.lock.writeLock();
            try {
                Clock tmp = this.clock;
                if (tmp == null) {
                    tmp = ClockProvider.resolveClock();
                }
                this.clock = tmp = (Clock)operator.apply(tmp);
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }

        private static Clock resolveClock() {
            String nowProperty = System.getProperty(DateTimeUtils.NOW_SYSTEM_PROPERTY_NAME);
            if (nowProperty == null) {
                return Clock.systemDefaultZone();
            }
            LocalDateTime dateTime = LocalDateTime.parse(nowProperty, FORMATTER);
            return Clock.fixed(dateTime.atZone(ZoneId.systemDefault()).toInstant(), ZoneId.systemDefault());
        }
    }
}

