/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ByteArrayUtils {
    public static final byte[] EMPTY_ARRAY = new byte[0];

    public static byte[] intToByteArray(int value) {
        byte[] bytes = new byte[4];
        ByteArrayUtils.storeIntInStartOfArray(value, bytes);
        return bytes;
    }

    public static byte[] intsToByteArray(int ... values) {
        byte[] bytes = new byte[4 * values.length];
        for (int i = 0; i < values.length; ++i) {
            ByteArrayUtils.storeIntInArray(values[i], bytes, i * 4);
        }
        return bytes;
    }

    public static void storeIntInStartOfArray(int value, byte[] bytes) {
        ByteArrayUtils.storeIntInArray(value, bytes, 0);
    }

    public static void storeIntInArray(int value, byte[] bytes, int startOffset) {
        bytes[startOffset] = (byte)(value >> 24);
        bytes[startOffset + 1] = (byte)(value >> 16);
        bytes[startOffset + 2] = (byte)(value >> 8);
        bytes[startOffset + 3] = (byte)value;
    }

    public static byte[] doubleToByteArray(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        return ByteArrayUtils.longToByteArray(longBits);
    }

    public static byte[] longToByteArray(long value) {
        byte[] bytes = new byte[8];
        ByteArrayUtils.putLongIntoByteArray(bytes, 0, value);
        return bytes;
    }

    public static int byteArrayToInt(byte[] bytes) {
        CCSMAssert.isTrue(bytes.length == 4, "bytes.length must be 4");
        return ByteArrayUtils.readIntFromStartOfArray(bytes);
    }

    public static int readIntFromStartOfArray(byte[] bytes) {
        return ByteArrayUtils.getIntFromByteArray(bytes, 0);
    }

    public static long byteArrayToLong(byte[] bytes) {
        CCSMAssert.isTrue(bytes.length == 8, "bytes.length must be 8");
        return ByteArrayUtils.getLongFromByteArray(bytes, 0);
    }

    public static double byteArrayToDouble(byte[] value) {
        long longBits = ByteArrayUtils.byteArrayToLong(value);
        return Double.longBitsToDouble(longBits);
    }

    public static OptionalLong byteArrayToOptionalLong(byte[] bytes) {
        if (bytes == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(ByteArrayUtils.byteArrayToLong(bytes));
    }

    public static byte[] decompress(byte[] value) throws IOException {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length);
        ByteArrayInputStream bis = new ByteArrayInputStream(value);
        GZIPInputStream gzis = new GZIPInputStream(bis);
        FileSystemUtils.copy(gzis, bos);
        gzis.close();
        bos.close();
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length);
        try {
            GZIPOutputStream gzos = new GZIPOutputStream(bos);
            gzos.write(value);
            gzos.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Can not happen as we work in memory: " + e.getMessage()));
        }
        return bos.toByteArray();
    }

    public static boolean isPrefix(byte[] prefix, byte[] key) {
        return ByteArrayUtils.isPrefix(prefix, key, 0);
    }

    public static boolean isPrefix(byte[] prefix, byte[] key, int startIndex) {
        if (key.length - startIndex < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (prefix[i] == key[i + startIndex]) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(byte[] searchFor, byte[] searchIn) {
        return ByteArrayUtils.contains(searchFor, searchIn, 0);
    }

    public static boolean contains(byte[] searchFor, byte[] searchIn, int startIndex) {
        return ByteArrayUtils.indexOf(searchFor, searchIn, startIndex) >= 0;
    }

    public static boolean isLess(byte[] a1, byte[] a2, boolean resultIfEqual) {
        int limit = Math.min(a1.length, a2.length);
        for (int i = 0; i < limit; ++i) {
            if (ByteArrayUtils.unsignedByte(a1[i]) < ByteArrayUtils.unsignedByte(a2[i])) {
                return true;
            }
            if (ByteArrayUtils.unsignedByte(a1[i]) <= ByteArrayUtils.unsignedByte(a2[i])) continue;
            return false;
        }
        if (a1.length < a2.length) {
            return true;
        }
        if (a1.length > a2.length) {
            return false;
        }
        return resultIfEqual;
    }

    public static int unsignedByte(byte b) {
        return b & 0xFF;
    }

    public static long unsignedByteAsLong(byte b) {
        return (long)b & 0xFFL;
    }

    public static byte[] concat(byte[] ... arrays) {
        return ByteArrayUtils.concat(Arrays.asList(arrays));
    }

    public static byte[] concat(Iterable<byte[]> arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] result = new byte[length];
        int start = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, start, array.length);
            start += array.length;
        }
        return result;
    }

    public static byte[] truncate(byte[] array, int newLength) {
        if (array.length < newLength) {
            return array;
        }
        byte[] truncated = new byte[newLength];
        System.arraycopy(array, 0, truncated, 0, newLength);
        return truncated;
    }

    public static String hexDump(byte[] data) {
        return ByteArrayUtils.hexDump(data, 16);
    }

    public static String hexDump(byte[] data, int width) {
        CCSMAssert.isTrue(width >= 1, "Width must be positive!");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length; i += width) {
            ByteArrayUtils.hexDumpAppendLine(data, i, Math.min(data.length, i + width), width, builder);
        }
        return builder.toString();
    }

    public static int getIntFromByteArray(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    public static byte[] serializeIntegerList(List<Integer> integers) {
        byte[] data = new byte[integers.size() * 4];
        for (int i = 0; i < integers.size(); ++i) {
            ByteArrayUtils.putIntIntoByteArray(data, i * 4, integers.get(i));
        }
        return data;
    }

    public static List<Integer> deserializeIntegerList(byte[] data) {
        int listSize = data.length / 4;
        ArrayList<Integer> result = new ArrayList<Integer>(listSize);
        for (int i = 0; i < listSize; ++i) {
            Integer value = ByteArrayUtils.getIntFromByteArray(data, 4 * i);
            result.add(value);
        }
        return result;
    }

    private static int readIntFromStream(ByteArrayInputStream inputStream) throws IOException {
        byte[] intBytes = new byte[4];
        int elementSize = inputStream.read(intBytes);
        if (elementSize == 0) {
            return 0;
        }
        if (elementSize != 4) {
            throw new IOException("Did expect an integer with 4 bytes");
        }
        return ByteArrayUtils.byteArrayToInt(intBytes);
    }

    public static long getLongFromByteArray(byte[] data, int offset) {
        return (long)(data[offset] & 0xFF) << 56 | (long)(data[offset + 1] & 0xFF) << 48 | (long)(data[offset + 2] & 0xFF) << 40 | (long)(data[offset + 3] & 0xFF) << 32 | (long)(data[offset + 4] & 0xFF) << 24 | (long)((data[offset + 5] & 0xFF) << 16) | (long)((data[offset + 6] & 0xFF) << 8) | (long)(data[offset + 7] & 0xFF);
    }

    public static double getDoubleFromByteArray(byte[] data, int offset) {
        return Double.longBitsToDouble(ByteArrayUtils.getLongFromByteArray(data, offset));
    }

    public static void putIntIntoByteArray(byte[] data, int offset, int value) {
        data[offset] = (byte)((value & 0xFF000000) >> 24);
        data[offset + 1] = (byte)((value & 0xFF0000) >> 16);
        data[offset + 2] = (byte)((value & 0xFF00) >> 8);
        data[offset + 3] = (byte)(value & 0xFF);
    }

    public static void putLongIntoByteArray(byte[] data, int offset, long value) {
        data[offset] = (byte)(value >>> 56);
        data[offset + 1] = (byte)(value >>> 48);
        data[offset + 2] = (byte)(value >>> 40);
        data[offset + 3] = (byte)(value >>> 32);
        data[offset + 4] = (byte)(value >>> 24);
        data[offset + 5] = (byte)(value >>> 16);
        data[offset + 6] = (byte)(value >>> 8);
        data[offset + 7] = (byte)value;
    }

    public static void putDoubleIntoByteArray(byte[] data, int offset, double value) {
        long longBits = Double.doubleToRawLongBits(value);
        ByteArrayUtils.putLongIntoByteArray(data, offset, longBits);
    }

    private static void hexDumpAppendLine(byte[] data, int startOffset, int endOffset, int width, StringBuilder builder) {
        int i;
        builder.append(String.format("%06d: ", startOffset));
        for (i = startOffset; i < endOffset; ++i) {
            builder.append(String.format("%02x ", data[i]));
        }
        if (endOffset - startOffset < width) {
            builder.append(StringUtils.fillString((width - (endOffset - startOffset)) * 3, ' '));
        }
        builder.append(' ');
        for (i = startOffset; i < endOffset; ++i) {
            boolean isInPrintableAsciiRange;
            boolean bl = isInPrintableAsciiRange = 33 <= data[i] && data[i] <= 126;
            if (isInPrintableAsciiRange) {
                builder.append((char)data[i]);
                continue;
            }
            builder.append('.');
        }
        builder.append(StringUtils.LINE_SEPARATOR);
    }

    public static boolean startsWithZipMagicBytes(byte[] data) {
        return ByteArrayUtils.isPrefix(new byte[]{80, 75, 3, 4}, data);
    }

    public static int indexOf(byte[] searchFor, byte[] searchIn, int startIndex) {
        return ByteArrayUtils.indexOf(searchFor, searchIn, startIndex, searchIn.length);
    }

    public static int indexOf(byte[] searchFor, byte[] searchIn, int startIndex, int endIndex) {
        if (startIndex >= endIndex || startIndex + searchFor.length > endIndex) {
            return -1;
        }
        for (int i = startIndex; i <= endIndex - searchFor.length; ++i) {
            if (!ByteArrayUtils.isPrefix(searchFor, searchIn, i)) continue;
            return i;
        }
        return -1;
    }

    public static List<byte[]> split(byte[] bytes, byte[] separatorBytes) {
        return ByteArrayUtils.split(bytes, separatorBytes, Integer.MAX_VALUE);
    }

    public static List<byte[]> split(byte[] bytes, byte[] separatorBytes, int maxSplits) {
        CCSMAssert.isNotNull((Object)separatorBytes, "Separator bytes for byte array split can't be null.");
        CCSMAssert.isTrue(separatorBytes.length > 0, "Separator bytes array must have positive length.");
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        if (maxSplits <= 0 || bytes == null) {
            return result;
        }
        int start = 0;
        for (int i = 0; i < bytes.length && result.size() != maxSplits - 1; ++i) {
            if (!ByteArrayUtils.isPrefix(separatorBytes, bytes, i)) continue;
            result.add(Arrays.copyOfRange(bytes, start, i));
            start = i += separatorBytes.length;
        }
        result.add(Arrays.copyOfRange(bytes, start, bytes.length));
        return result;
    }

    public static byte[] removePrefix(byte[] prefix, byte[] data) {
        if (ByteArrayUtils.isPrefix(prefix, data)) {
            return Arrays.copyOfRange(data, prefix.length, data.length);
        }
        return data;
    }
}

