/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.visitor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.visitor.IMeshWalker;
import org.conqat.lib.commons.visitor.ITreeWalker;
import org.conqat.lib.commons.visitor.IVisitor;

public class VisitorUtils {
    public static <T, X1 extends Exception, X2 extends Exception> void visitAllPreOrder(T root, ITreeWalker<T, X1> walker, IVisitor<T, X2> visitor) throws X1, X2 {
        visitor.visit(root);
        for (T child : walker.getChildren(root)) {
            VisitorUtils.visitAllPreOrder(child, walker, visitor);
        }
    }

    public static <T, X1 extends Exception, X2 extends Exception> void visitLeaves(T root, ITreeWalker<T, X1> walker, IVisitor<T, X2> visitor) throws X1, X2 {
        Collection<T> children = walker.getChildren(root);
        if (children.isEmpty()) {
            visitor.visit(root);
        } else {
            for (T child : children) {
                VisitorUtils.visitLeaves(child, walker, visitor);
            }
        }
    }

    public static <T, X1 extends Exception, X2 extends Exception> void visitAllDepthFirst(T start, IMeshWalker<T, X1> walker, IVisitor<T, X2> visitor) throws X1, X2 {
        IdentityHashSet visitedNodes = new IdentityHashSet();
        ArrayDeque<T> todoNodes = new ArrayDeque<T>();
        todoNodes.addFirst(start);
        while (!todoNodes.isEmpty()) {
            Object current = todoNodes.removeFirst();
            if (visitedNodes.contains(current)) continue;
            visitor.visit(current);
            visitedNodes.add(current);
            for (T succ : CollectionUtils.reverse(walker.getAdjacentElements(current))) {
                if (visitedNodes.contains(succ)) continue;
                todoNodes.addFirst(succ);
            }
        }
    }

    public static <T, X extends Exception> List<T> listAllDepthFirst(T start, IMeshWalker<T, X> walker) throws X {
        ArrayList list = new ArrayList();
        VisitorUtils.visitAllDepthFirst(start, walker, list::add);
        return list;
    }
}

