/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.LDAPSDKRuntimeException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPRuntimeException
extends LDAPSDKRuntimeException {
    private static final long serialVersionUID = 6201514484547092642L;
    @NotNull
    private final LDAPException ldapException;

    public LDAPRuntimeException(@NotNull LDAPException ldapException) {
        super(ldapException.getMessage(), ldapException.getCause());
        this.ldapException = ldapException;
    }

    @NotNull
    public LDAPException getLDAPException() {
        return this.ldapException;
    }

    public void throwLDAPException() throws LDAPException {
        throw this.ldapException;
    }

    @NotNull
    public ResultCode getResultCode() {
        return this.ldapException.getResultCode();
    }

    @Nullable
    public String getMatchedDN() {
        return this.ldapException.getMatchedDN();
    }

    @Nullable
    public String getDiagnosticMessage() {
        return this.ldapException.getDiagnosticMessage();
    }

    @NotNull
    public String[] getReferralURLs() {
        return this.ldapException.getReferralURLs();
    }

    public boolean hasResponseControl() {
        return this.ldapException.hasResponseControl();
    }

    public boolean hasResponseControl(@NotNull String oid) {
        return this.ldapException.hasResponseControl(oid);
    }

    @NotNull
    public Control[] getResponseControls() {
        return this.ldapException.getResponseControls();
    }

    @Nullable
    public Control getResponseControl(@NotNull String oid) {
        return this.ldapException.getResponseControl(oid);
    }

    @NotNull
    public LDAPResult toLDAPResult() {
        return this.ldapException.toLDAPResult();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        this.ldapException.toString(buffer);
    }

    @Override
    @NotNull
    public String getExceptionMessage() {
        return this.ldapException.getExceptionMessage();
    }

    @Override
    @NotNull
    public String getExceptionMessage(boolean includeStackTrace, boolean includeCause) {
        return this.ldapException.getExceptionMessage(includeStackTrace, includeCause);
    }
}

