/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.embedded.server;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpFilterHandler;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.embedded.server.CorsFilter;
import org.sonarsource.sonarlint.core.embedded.server.GeneratedUserTokenHandler;
import org.sonarsource.sonarlint.core.embedded.server.ShowHotspotRequestHandler;
import org.sonarsource.sonarlint.core.embedded.server.ShowIssueRequestHandler;
import org.sonarsource.sonarlint.core.embedded.server.StatusRequestHandler;

@Named
@Singleton
public class EmbeddedServer {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final int STARTING_PORT = 64120;
    private static final int ENDING_PORT = 64130;
    private static final int INVALID_PORT = -1;
    private HttpServer server;
    private int port;
    private final boolean enabled;
    private final StatusRequestHandler statusRequestHandler;
    private final GeneratedUserTokenHandler generatedUserTokenHandler;
    private final ShowHotspotRequestHandler showHotspotRequestHandler;
    private final ShowIssueRequestHandler showIssueRequestHandler;

    public EmbeddedServer(InitializeParams params, StatusRequestHandler statusRequestHandler, GeneratedUserTokenHandler generatedUserTokenHandler, ShowHotspotRequestHandler showHotspotRequestHandler, ShowIssueRequestHandler showIssueRequestHandler) {
        this.enabled = params.getFeatureFlags().shouldManageLocalServer();
        this.statusRequestHandler = statusRequestHandler;
        this.generatedUserTokenHandler = generatedUserTokenHandler;
        this.showHotspotRequestHandler = showHotspotRequestHandler;
        this.showIssueRequestHandler = showIssueRequestHandler;
    }

    @PostConstruct
    public void start() {
        if (!this.enabled) {
            return;
        }
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(15, TimeUnit.SECONDS).setSoReuseAddress(true).setTcpNoDelay(true).build();
        this.port = -1;
        int triedPort = 64120;
        HttpServer startedServer = null;
        while (this.port < 0 && triedPort <= 64130) {
            try {
                startedServer = ServerBootstrap.bootstrap().setLocalAddress(InetAddress.getLoopbackAddress()).setConnectionReuseStrategy((ConnectionReuseStrategy)new DontKeepAliveReuseStrategy()).setListenerPort(triedPort).setSocketConfig(socketConfig).addFilterFirst("CORS", (HttpFilterHandler)new CorsFilter()).register("/sonarlint/api/status", (HttpRequestHandler)this.statusRequestHandler).register("/sonarlint/api/token", (HttpRequestHandler)this.generatedUserTokenHandler).register("/sonarlint/api/hotspots/show", (HttpRequestHandler)this.showHotspotRequestHandler).register("/sonarlint/api/issues/show", (HttpRequestHandler)this.showIssueRequestHandler).create();
                startedServer.start();
                this.port = triedPort;
            }
            catch (Exception t) {
                LOG.debug("Error while starting port: " + triedPort + ", " + t.getMessage());
                ++triedPort;
                if (startedServer == null) continue;
                startedServer.close();
            }
        }
        if (this.port > 0) {
            LOG.info("Started embedded server on port " + this.port);
            this.server = startedServer;
        } else {
            LOG.error("Unable to start request handler");
            this.server = null;
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isStarted() {
        return this.server != null;
    }

    @PreDestroy
    public void shutdown() {
        if (this.isStarted()) {
            this.server.close(CloseMode.GRACEFUL);
            this.server = null;
            this.port = -1;
        }
    }

    private static class DontKeepAliveReuseStrategy
    implements ConnectionReuseStrategy {
        private DontKeepAliveReuseStrategy() {
        }

        public boolean keepAlive(HttpRequest request, HttpResponse response, HttpContext context) {
            return false;
        }
    }
}

