/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.Language;

public interface SkipReason {

    public static class UnsatisfiedRuntimeRequirement
    implements SkipReason {
        private final RuntimeRequirement runtime;
        private final String currentVersion;
        private final String minVersion;

        public UnsatisfiedRuntimeRequirement(RuntimeRequirement runtime, @Nullable String currentVersion, String minVersion) {
            this.runtime = runtime;
            this.currentVersion = currentVersion;
            this.minVersion = minVersion;
        }

        public RuntimeRequirement getRuntime() {
            return this.runtime;
        }

        @CheckForNull
        public String getCurrentVersion() {
            return this.currentVersion;
        }

        public String getMinVersion() {
            return this.minVersion;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.runtime, this.currentVersion, this.minVersion});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UnsatisfiedRuntimeRequirement)) {
                return false;
            }
            UnsatisfiedRuntimeRequirement other = (UnsatisfiedRuntimeRequirement)obj;
            return this.runtime == other.runtime && Objects.equals(this.currentVersion, other.currentVersion) && Objects.equals(this.minVersion, other.minVersion);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UnsatisfiedRuntimeRequirement [runtime=").append((Object)this.runtime).append(", currentVersion=").append(this.currentVersion).append(", minVersion=").append(this.minVersion).append("]");
            return builder.toString();
        }

        public static enum RuntimeRequirement {
            JRE,
            NODEJS;

        }
    }

    public static class IncompatiblePluginVersion
    implements SkipReason {
        private final String minVersion;

        public IncompatiblePluginVersion(String minVersion) {
            this.minVersion = minVersion;
        }

        public String getMinVersion() {
            return this.minVersion;
        }

        public int hashCode() {
            return Objects.hash(this.minVersion);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IncompatiblePluginVersion)) {
                return false;
            }
            IncompatiblePluginVersion other = (IncompatiblePluginVersion)obj;
            return Objects.equals(this.minVersion, other.minVersion);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IncompatiblePluginVersion [minVersion=").append(this.minVersion).append("]");
            return builder.toString();
        }
    }

    public static class UnsatisfiedDependency
    implements SkipReason {
        private final String dependencyKey;

        public UnsatisfiedDependency(String dependencyKey) {
            this.dependencyKey = dependencyKey;
        }

        public String getDependencyKey() {
            return this.dependencyKey;
        }

        public int hashCode() {
            return Objects.hash(this.dependencyKey);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UnsatisfiedDependency)) {
                return false;
            }
            UnsatisfiedDependency other = (UnsatisfiedDependency)obj;
            return Objects.equals(this.dependencyKey, other.dependencyKey);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UnsatisfiedDependency [dependencyKey=").append(this.dependencyKey).append("]");
            return builder.toString();
        }
    }

    public static class LanguagesNotEnabled
    implements SkipReason {
        private final Set<Language> languages;

        public LanguagesNotEnabled(Collection<Language> languages) {
            this.languages = new LinkedHashSet<Language>(languages);
        }

        public Set<Language> getNotEnabledLanguages() {
            return this.languages;
        }

        public int hashCode() {
            return Objects.hash(this.languages);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LanguagesNotEnabled)) {
                return false;
            }
            LanguagesNotEnabled other = (LanguagesNotEnabled)obj;
            return Objects.equals(this.languages, other.languages);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LanguagesNotEnabled [languages=").append(this.languages).append("]");
            return builder.toString();
        }
    }

    public static class IncompatiblePluginApi
    implements SkipReason {
        public static final IncompatiblePluginApi INSTANCE = new IncompatiblePluginApi();

        private IncompatiblePluginApi() {
        }
    }

    public static class UnsupportedPlugin
    implements SkipReason {
        public static final UnsupportedPlugin INSTANCE = new UnsupportedPlugin();

        private UnsupportedPlugin() {
        }
    }
}

