/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.ByteBuffer;
import org.rocksdb.DirectSlice;
import org.rocksdb.EnvOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;
import org.rocksdb.Slice;

public class SstFileWriter
extends RocksObject {
    public SstFileWriter(EnvOptions envOptions, Options options) {
        super(SstFileWriter.newSstFileWriter(envOptions.nativeHandle_, options.nativeHandle_));
    }

    public void open(String filePath) throws RocksDBException {
        this.open(this.nativeHandle_, filePath);
    }

    public void put(Slice key, Slice value) throws RocksDBException {
        this.put(this.nativeHandle_, key.getNativeHandle(), value.getNativeHandle());
    }

    public void put(DirectSlice key, DirectSlice value) throws RocksDBException {
        this.put(this.nativeHandle_, key.getNativeHandle(), value.getNativeHandle());
    }

    public void put(ByteBuffer key, ByteBuffer value) throws RocksDBException {
        assert (key.isDirect() && value.isDirect());
        this.putDirect(this.nativeHandle_, key, key.position(), key.remaining(), value, value.position(), value.remaining());
        key.position(key.limit());
        value.position(value.limit());
    }

    public void put(byte[] key, byte[] value) throws RocksDBException {
        this.put(this.nativeHandle_, key, value);
    }

    public void merge(Slice key, Slice value) throws RocksDBException {
        this.merge(this.nativeHandle_, key.getNativeHandle(), value.getNativeHandle());
    }

    public void merge(byte[] key, byte[] value) throws RocksDBException {
        this.merge(this.nativeHandle_, key, value);
    }

    public void merge(DirectSlice key, DirectSlice value) throws RocksDBException {
        this.merge(this.nativeHandle_, key.getNativeHandle(), value.getNativeHandle());
    }

    public void delete(Slice key) throws RocksDBException {
        this.delete(this.nativeHandle_, key.getNativeHandle());
    }

    public void delete(DirectSlice key) throws RocksDBException {
        this.delete(this.nativeHandle_, key.getNativeHandle());
    }

    public void delete(byte[] key) throws RocksDBException {
        this.delete(this.nativeHandle_, key);
    }

    public void finish() throws RocksDBException {
        this.finish(this.nativeHandle_);
    }

    public long fileSize() throws RocksDBException {
        return this.fileSize(this.nativeHandle_);
    }

    private static native long newSstFileWriter(long var0, long var2, long var4, byte var6);

    private static native long newSstFileWriter(long var0, long var2);

    private native void open(long var1, String var3) throws RocksDBException;

    private native void put(long var1, long var3, long var5) throws RocksDBException;

    private native void put(long var1, byte[] var3, byte[] var4) throws RocksDBException;

    private native void putDirect(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8) throws RocksDBException;

    private native long fileSize(long var1) throws RocksDBException;

    private native void merge(long var1, long var3, long var5) throws RocksDBException;

    private native void merge(long var1, byte[] var3, byte[] var4) throws RocksDBException;

    private native void delete(long var1, long var3) throws RocksDBException;

    private native void delete(long var1, byte[] var3) throws RocksDBException;

    private native void finish(long var1) throws RocksDBException;

    @Override
    protected final native void disposeInternal(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

