/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import com.teamscale.commons.TeamscaleInstallationUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.conqat.engine.core.logging.TeamscaleLogAppender;

public class LoggingUtils {
    public static final Marker INTERACTION = MarkerManager.getMarker((String)"Interaction");
    public static final Marker DOWN_CONNECTOR_STATUS = MarkerManager.getMarker((String)"down-connector-status");
    public static final Logger FLICKER_DEBUG_LOGGER = LogManager.getLogger((String)"flicker-debug");
    public static final Logger OPERATIONS_LOGGER = LogManager.getLogger((String)"operations-log");
    private static final String LOG4J_1_CONFIG_FILE = "logging.properties";
    private static boolean loggerInitialized = false;

    public static synchronized void initLogger() {
        if (loggerInitialized) {
            return;
        }
        loggerInitialized = true;
        if (TeamscaleInstallationUtils.locateConfigFile((String)LOG4J_1_CONFIG_FILE).isPresent()) {
            System.err.println("It looks like there's an outdated Log4J 1 configuration file in your config directory. Please make sure to update the configuration file to a Log4J 2 compatible format (see https://logging.apache.org/log4j/2.x/manual/configuration.html).");
            System.exit(-1);
        }
        TeamscaleLogAppender.init();
        LoggingUtils.failOnInvalidConfiguration();
    }

    private static void failOnInvalidConfiguration() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        if (configuration instanceof DefaultConfiguration) {
            System.err.println("No valid logger configuration found! Teamscale needs a valid Log4j 2 configuration file to work (see https://logging.apache.org/log4j/2.x/manual/configuration.html).");
            System.exit(-1);
        } else if (configuration instanceof BuiltConfiguration) {
            LogManager.getLogger().warn("No logging configuration found. Logging to console!");
        } else if (configuration.getConfigurationSource().getLocation() == null) {
            LogManager.getLogger().info("Logger configured from environment variable TS_LOGGING_CONF");
        } else {
            LogManager.getLogger().info("Logger configured from: " + configuration.getConfigurationSource().getLocation());
        }
    }

    public static boolean isInteractionLog(LogEvent logEvent) {
        Marker marker = logEvent.getMarker();
        return marker != null && marker.isInstanceOf(INTERACTION);
    }

    public static boolean isParseLog(LogEvent logEvent) {
        Marker marker = logEvent.getMarker();
        return marker != null && marker.isInstanceOf(ShallowParsingUtils.PARSE_LOG_ENTRY_MARKER);
    }
}

