/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.stream.ConcatenatedStreamSource;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.function.SupplierWithException;

public interface IStreamSource<T, E extends Exception>
extends AutoCloseable {
    public boolean tryAdvance(Consumer<? super T> var1) throws E;

    public Class<E> exceptionType();

    @Override
    default public void close() throws E {
    }

    default public long estimateSize() throws E {
        return Long.MAX_VALUE;
    }

    default public long getExactSizeIfKnown() throws E {
        if ((this.characteristics() & 0x40) == 0) {
            return -1L;
        }
        return this.estimateSize();
    }

    default public int characteristics() throws E {
        return 0;
    }

    default public Comparator<? super T> getComparator() {
        throw new IllegalStateException();
    }

    public static <T, E extends Exception> IStreamSource<T, E> ofSpliterator(Spliterator<T> spliterator, Class<E> exceptionType) {
        return IStreamSource.ofSpliterator(spliterator, null, exceptionType);
    }

    public static <T, E extends Exception> IStreamSource<T, E> ofSpliterator(final Spliterator<T> spliterator, final @Nullable RunnableWithException<E> onClose, final Class<E> exceptionType) {
        CCSMAssert.isNotNull(spliterator, () -> String.format("Expected \"%s\" to be not null", "spliterator"));
        CCSMAssert.isNotNull(exceptionType, () -> String.format("Expected \"%s\" to be not null", "exceptionType"));
        return new IStreamSource<T, E>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return spliterator.tryAdvance(action);
            }

            @Override
            public void close() throws Exception {
                if (onClose != null) {
                    onClose.run();
                }
            }

            @Override
            public Class<E> exceptionType() {
                return exceptionType;
            }

            @Override
            public long estimateSize() {
                return spliterator.estimateSize();
            }

            @Override
            public long getExactSizeIfKnown() {
                return spliterator.getExactSizeIfKnown();
            }

            @Override
            public int characteristics() {
                return spliterator.characteristics();
            }

            @Override
            public Comparator<? super T> getComparator() {
                return spliterator.getComparator();
            }
        };
    }

    public static <T, E extends Exception> IStreamSource<T, E> ofIterator(Iterator<T> iterator, Class<E> exceptionType) {
        return IStreamSource.ofIterator(iterator, null, exceptionType);
    }

    public static <T, E extends Exception> IStreamSource<T, E> ofIterator(final Iterator<T> iterator, final @Nullable RunnableWithException<E> onClose, final Class<E> exceptionType) {
        CCSMAssert.isNotNull(iterator, () -> String.format("Expected \"%s\" to be not null", "iterator"));
        CCSMAssert.isNotNull(exceptionType, () -> String.format("Expected \"%s\" to be not null", "exceptionType"));
        return new IStreamSource<T, E>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                boolean hadElement = iterator.hasNext();
                if (hadElement) {
                    action.accept(iterator.next());
                }
                return hadElement;
            }

            @Override
            public void close() throws Exception {
                if (onClose != null) {
                    onClose.run();
                }
            }

            @Override
            public Class<E> exceptionType() {
                return exceptionType;
            }
        };
    }

    public static <T, E extends Exception> IStreamSource<T, E> ofIterable(Iterable<T> iterable, Class<E> exceptionType) {
        return IStreamSource.ofIterable(iterable, null, exceptionType);
    }

    public static <T, E extends Exception> IStreamSource<T, E> ofIterable(Iterable<T> iterable, RunnableWithException<E> onClose, Class<E> exceptionType) {
        return IStreamSource.ofIterator(iterable.iterator(), onClose, exceptionType);
    }

    @SafeVarargs
    public static <T, E extends Exception> IStreamSource<T, E> of(Class<E> exceptionType, T first, T ... further) {
        return IStreamSource.of(exceptionType, null, first, further);
    }

    @SafeVarargs
    public static <T, E extends Exception> IStreamSource<T, E> of(Class<E> exceptionType, RunnableWithException<E> onClose, final T first, final T ... further) {
        Iterator iter = new Iterator<T>(){
            int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < further.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.index < 0) {
                    this.index = 0;
                    return first;
                }
                return further[this.index++];
            }
        };
        return IStreamSource.ofIterator(iter, onClose, exceptionType);
    }

    public static <T, E extends Exception> IStreamSource<T, E> lazySource(@NonNull SupplierWithException<@NonNull IStreamSource<T, E>, E> supplier, @NonNull Class<E> exceptionType, final int characteristics, final long exactSize, final @Nullable Comparator<? super T> comparator) {
        CCSMAssert.isNotNull(supplier, () -> String.format("Expected \"%s\" to be not null", "supplier"));
        CCSMAssert.isNotNull(exceptionType, () -> String.format("Expected \"%s\" to be not null", "exceptionType"));
        class LazyStreamSource
        implements IStreamSource<T, E> {
            private final Class<E> exceptionType;
            private volatile SupplierWithException<IStreamSource<T, E>, E> supplier;
            private IStreamSource<T, E> delegate;

            private LazyStreamSource(SupplierWithException<IStreamSource<T, E>, E> supplier, Class<E> exceptionType) {
                this.supplier = supplier;
                this.exceptionType = exceptionType;
            }

            private boolean isInitialized() {
                return this.supplier == null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private IStreamSource<T, E> initDelegate() throws Exception {
                if (!this.isInitialized()) {
                    LazyStreamSource lazyStreamSource = this;
                    synchronized (lazyStreamSource) {
                        if (!this.isInitialized()) {
                            this.delegate = Objects.requireNonNull((IStreamSource)this.supplier.get(), "Supplier provided null result");
                            this.supplier = null;
                        }
                    }
                }
                return this.delegate;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) throws Exception {
                return this.initDelegate().tryAdvance(action);
            }

            @Override
            public Class<E> exceptionType() {
                return this.exceptionType;
            }

            @Override
            public void close() throws Exception {
                if (this.isInitialized()) {
                    this.delegate.close();
                }
            }

            @Override
            public long estimateSize() throws Exception {
                if (this.isInitialized()) {
                    return this.delegate.estimateSize();
                }
                if (this.hasCharacteristics(64)) {
                    return exactSize;
                }
                return Long.MAX_VALUE;
            }

            @Override
            public long getExactSizeIfKnown() throws Exception {
                if (this.isInitialized()) {
                    return this.delegate.getExactSizeIfKnown();
                }
                if (this.hasCharacteristics(64)) {
                    return exactSize;
                }
                return -1L;
            }

            @Override
            public int characteristics() throws Exception {
                if (this.isInitialized()) {
                    return this.delegate.characteristics();
                }
                return characteristics;
            }

            @Override
            public Comparator<? super T> getComparator() {
                if (this.isInitialized()) {
                    return this.delegate.getComparator();
                }
                if (this.hasCharacteristics(4)) {
                    return comparator;
                }
                throw new IllegalStateException();
            }

            private boolean hasCharacteristics(int characteristic) {
                return (characteristics & characteristic) == characteristic;
            }
        }
        return new LazyStreamSource(supplier, exceptionType);
    }

    @SafeVarargs
    public static <T, E extends Exception> IStreamSource<T, E> concat(IStreamSource<T, E> first, IStreamSource<T, E> ... further) {
        CCSMAssert.isNotNull(first, () -> String.format("Expected \"%s\" to be not null", "first"));
        CCSMAssert.isNotNull(further, () -> String.format("Expected \"%s\" to be not null", "further"));
        return IStreamSource.concat(first, Arrays.asList(further));
    }

    public static <T, E extends Exception> IStreamSource<T, E> concat(IStreamSource<T, E> first, Collection<IStreamSource<T, E>> further) {
        CCSMAssert.isNotNull(first, () -> String.format("Expected \"%s\" to be not null", "first"));
        CCSMAssert.isNotNull(further, () -> String.format("Expected \"%s\" to be not null", "further"));
        ArrayList sources = new ArrayList(further.size() + 1);
        sources.add(first);
        sources.addAll(further);
        return new ConcatenatedStreamSource(sources, first.exceptionType());
    }
}

