/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.audit.csv.AuditOptionAndMetricDataRow;
import com.teamscale.service.audit.latex.ProjectDataAccessor;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.supercsv.cellprocessor.ConvertNullTo;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

@Path(value="api/projects/{project}/audit/data-export")
public class AuditDataExportService
extends ApiBase {
    private static final String GENERAL_INDICATOR = "General";
    private static final String GENERAL_GROUP = "General";
    private static final String EXCEPTION_HANDLING_QUALITY_INDICATOR = "Exception Handling";
    private static final String EXCEPTION_CATCH_GROUP_NAME = "Catch";
    private static final String EXCEPTION_THROW_GROUP_NAME = "Throw";
    private static final String NO_VALUE = "<no value>";
    private static final String[] HEADER = new String[]{"Quality Indicator", "Analysis Group", "Option Name", "Option Value", "Metric Value"};
    private static final String[] FIELDS = new String[]{"qualityIndicator", "analysisGroup", "optionName", "optionValue", "metricValue"};
    private static final Set<String> GROUP_NAMES = new HashSet<String>();
    private final CellProcessor[] processors = new CellProcessor[]{new NotNull(), new NotNull(), new NotNull(), new ConvertNullTo((Object)"<no value>"), new ConvertNullTo((Object)"<no value>")};
    private ProjectDataAccessor projectDataAccessor;
    private AnalysisProfile analysisProfile;
    private ArrayList<AuditOptionAndMetricDataRow> rows;

    @Operation(summary="Get audit data", description="Download audit result data for export. Result data is represented with a CSV file.")
    @Path(value="{uniformPath: .*}")
    @GET
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    @Produces(value={"text/csv"})
    public Response downloadAuditData(@Parameter(description="The uniform path") @PathParam(value="uniformPath") UniformPath uniformPath) throws StorageException, IOException {
        this.initService(this.serviceInfo.getPrimaryPublicId(), uniformPath);
        String entity = this.getProfileAndMetricsCSV();
        String fileName = String.valueOf(this.serviceInfo.getPrimaryPublicId()) + "-audit-data.csv";
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)fileName);
    }

    private void initService(PublicProjectId projectId, UniformPath uniformPath) throws StorageException {
        this.projectDataAccessor = new ProjectDataAccessor((ProjectStorageSystem)this.getProjectStorageSystem(), this.readDefaultBranchHead(), projectId, null, uniformPath);
        this.analysisProfile = AnalysisProfileUtils.getDefaultEmbeddedAnalysisProfile((ProjectStorageSystem)this.getProjectStorageSystem());
    }

    private String getProfileAndMetricsCSV() throws StorageException, IOException {
        this.rows = new ArrayList();
        this.addGeneralProjectMetrics();
        this.addIndexedMetrics();
        this.addAdditionalMetrics();
        Collections.sort(this.rows);
        return this.createCSV();
    }

    private void addRowFor(String qualityIndicator, String analysisGroup, String optionName, String optionValue, Object metricValue) {
        this.rows.add(new AuditOptionAndMetricDataRow(qualityIndicator, analysisGroup, optionName, optionValue, metricValue));
    }

    private void addRowFor(String qualityIndicator, String analysisGroup, String optionName, Object metricValue) {
        this.rows.add(new AuditOptionAndMetricDataRow(qualityIndicator, analysisGroup, optionName, null, metricValue));
    }

    private void addRowForGeneralMetric(String optionName) throws AssertionError {
        Object metricValue = this.projectDataAccessor.getMetricValue(optionName);
        if (metricValue instanceof Number) {
            this.addRowFor("General", "General", optionName, ((Number)metricValue).intValue());
            return;
        }
        CCSMAssert.fail((String)("General metric value has type " + String.valueOf(metricValue.getClass()) + " instead of the expected type Number."));
    }

    private void addRowForCommentMetric(String optionName, Object metricValue) {
        this.addRowFor("Documentation", "Comment Completeness", optionName, metricValue);
    }

    private void addRowForExceptionMetric(String analysisGroup, String optionName, Object metricValue) {
        this.addRowFor(EXCEPTION_HANDLING_QUALITY_INDICATOR, analysisGroup, optionName, metricValue);
    }

    private void addRowForCloningMetric(String optionName, Object metricValue) {
        this.addRowFor("Redundancy", "Code Clones", optionName, metricValue);
    }

    private void addGeneralProjectMetrics() throws AssertionError {
        this.addRowForGeneralMetric("Files");
        this.addRowForGeneralMetric("Lines of Code");
        this.addRowForGeneralMetric("Source Lines of Code");
    }

    private void addIndexedMetrics() throws AssertionError {
        for (QualityIndicator qualityIndicator : this.analysisProfile.getQualityIndicators()) {
            this.addRowsForQualityIndicator(qualityIndicator);
        }
    }

    private void addAdditionalMetrics() throws StorageException, AssertionError {
        this.addAdditionalCloningMetrics();
        this.addAdditionalExceptionMetrics();
        this.addAdditionalCommentMetrics();
    }

    private void addAdditionalCommentMetrics() throws StorageException, AssertionError {
        this.addRowForCommentMetric("Task age median by months", this.projectDataAccessor.getTaskAgeMedianByMonths());
        this.addRowForCommentMetric("Mean task age by months", this.projectDataAccessor.getMeanTaskAgeByMonths());
        this.addRowForCommentMetric("Copyright Completeness", this.projectDataAccessor.getNumberOfCopyrightCompletenessFindings());
    }

    private void addAdditionalExceptionMetrics() throws StorageException, AssertionError {
        this.addRowForExceptionMetric("General", "Custom exceptions", this.projectDataAccessor.getNumberOfCustomExceptions());
        this.addRowForExceptionMetric(EXCEPTION_CATCH_GROUP_NAME, "Files with high level catch", this.projectDataAccessor.getNumberOfFilesWithHighLevelCatch());
        this.addRowForExceptionMetric(EXCEPTION_CATCH_GROUP_NAME, "Files with Null Pointer Exception catch", this.projectDataAccessor.getNumberOfFilesWithNullPointerExceptionCatch());
        this.addRowForExceptionMetric(EXCEPTION_THROW_GROUP_NAME, "Files with high level throws", this.projectDataAccessor.getNumberOfFilesWithHighLevelThrows());
        this.addRowForExceptionMetric(EXCEPTION_CATCH_GROUP_NAME, "Empty Catch Blocks", this.projectDataAccessor.getNumberOfEmptyCatchBlocks());
    }

    private void addAdditionalCloningMetrics() throws StorageException {
        this.addRowForCloningMetric("Longest Clone", this.projectDataAccessor.getLongestCloneMetric());
        this.addRowForCloningMetric("Most Clone Instances", this.projectDataAccessor.getMostFrequentCloneMetric());
        this.addRowForCloningMetric("Clones", this.projectDataAccessor.getNumberOfClones());
        this.addRowForCloningMetric("Most frequent clone", this.projectDataAccessor.getMostFrequentCloneMetric());
    }

    private void addRowsForQualityIndicator(QualityIndicator qualityIndicator) throws AssertionError {
        for (AnalysisGroup analysisGroup : qualityIndicator.getGroups()) {
            if (!GROUP_NAMES.contains(analysisGroup.getName())) continue;
            this.addRowsForAnalysisGroup(qualityIndicator, analysisGroup);
        }
    }

    private void addRowsForAnalysisGroup(QualityIndicator qualityIndicator, AnalysisGroup analysisGroup) throws AssertionError {
        for (String optionName : analysisGroup.getOptionNames()) {
            if (this.projectDataAccessor.metricSchemaHasValue(optionName)) {
                this.addRowFor(qualityIndicator.getName(), analysisGroup.getName(), optionName, analysisGroup.getOptionValue(optionName), this.projectDataAccessor.getMetricValue(optionName));
                continue;
            }
            this.addRowFor(qualityIndicator.getName(), analysisGroup.getName(), optionName, analysisGroup.getOptionValue(optionName), null);
        }
    }

    private String createCSV() throws IOException {
        StringWriter stringWriter = new StringWriter();
        try (CsvBeanWriter beanWriter = new CsvBeanWriter((Writer)stringWriter, CsvPreference.EXCEL_PREFERENCE);){
            beanWriter.writeHeader(HEADER);
            for (AuditOptionAndMetricDataRow line : this.rows) {
                beanWriter.write((Object)line, FIELDS, this.processors);
            }
        }
        return stringWriter.toString();
    }

    static {
        GROUP_NAMES.add("Comment Completeness");
        GROUP_NAMES.add("Code Clones");
        GROUP_NAMES.add("File Size");
        GROUP_NAMES.add("Method Length");
        GROUP_NAMES.add("Nesting Depth");
    }
}

