/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.structure.LOCAnalyzer;
import com.teamscale.index.structure.LongestStatementListAnalyzerBase;
import com.teamscale.index.structure.ShallowParsedStatementNestingDepthAnalyzer;
import com.teamscale.service.audit.EAuditExportLanguage;
import com.teamscale.service.audit.EAuditExportTable;
import com.teamscale.service.audit.latex.CloneMetricsTableCreator;
import com.teamscale.service.audit.latex.CommentTableCreator;
import com.teamscale.service.audit.latex.LatexTableCreatorBase;
import com.teamscale.service.audit.latex.ProjectDataAccessor;
import com.teamscale.service.audit.latex.StructureMetricAssessmentTableCreator;
import com.teamscale.service.base.ApiBase;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class LatexTableExportServiceBase
extends ApiBase {
    protected static String getLatexTable(EAuditExportTable tableType, EAuditExportLanguage language, ProjectDataAccessor mainProjectAccessor, ProjectDataAccessor ... subProjectAccessors) throws StorageException {
        LatexTableCreatorBase tableCreator = LatexTableExportServiceBase.getTableCreator(tableType, language, mainProjectAccessor, subProjectAccessors);
        return tableCreator.createTable();
    }

    private static LatexTableCreatorBase getTableCreator(EAuditExportTable tableType, EAuditExportLanguage language, ProjectDataAccessor mainProjectAccessor, ProjectDataAccessor ... subProjectAccessors) throws AssertionError {
        switch (tableType) {
            case FILE_SIZE: {
                return new StructureMetricAssessmentTableCreator("File Size Assessment", "File Size", LOCAnalyzer.getFindingTypeId(), language, mainProjectAccessor, subProjectAccessors);
            }
            case METHOD_LENGTH: {
                return new StructureMetricAssessmentTableCreator("Method Length Assessment", "Method Length", LongestStatementListAnalyzerBase.getFindingTypeId(), language, mainProjectAccessor, subProjectAccessors);
            }
            case NESTING_DEPTH: {
                return new StructureMetricAssessmentTableCreator("Nesting Depth Assessment", "Nesting Depth", ShallowParsedStatementNestingDepthAnalyzer.getFindingTypeId(), language, mainProjectAccessor, subProjectAccessors);
            }
            case CLONING: {
                return new CloneMetricsTableCreator(language, mainProjectAccessor, subProjectAccessors);
            }
            case COMMENT_COMPLETENESS: {
                return new CommentTableCreator(language, mainProjectAccessor, subProjectAccessors);
            }
        }
        CCSMAssert.fail((String)("Unknown table type: " + String.valueOf((Object)tableType)));
        return null;
    }

    protected ProjectDataAccessor createProjectDataAccessor(String projectName, String projectAlias, UniformPath uniformPath) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.serviceInfo.getProjectStorageSystem((IProjectId)new PublicProjectId(projectName));
        HistoryAccessOption defaultBranchHistoryOption = HistoryAccessOption.readHead((String)ApiBase.getDefaultBranchName((ProjectStorageSystem)projectStorageSystem));
        return new ProjectDataAccessor((ProjectStorageSystem)projectStorageSystem, defaultBranchHistoryOption, new PublicProjectId(projectName), new PublicProjectId(projectAlias), uniformPath);
    }

    protected static class LatexTableExportParameters {
        @Parameter(description="The language in which a table is created.", required=true)
        @QueryParam(value="language")
        protected EAuditExportLanguage language;
        @Parameter(description="The table types containing specific metrics.", required=true)
        @QueryParam(value="table-type")
        protected List<EAuditExportTable> metrics;

        protected LatexTableExportParameters() {
        }
    }
}

