/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.latex;

import com.teamscale.service.audit.EAuditExportLanguage;
import com.teamscale.service.audit.EAuditMessageKey;
import com.teamscale.service.audit.latex.LatexTableCreatorBase;
import com.teamscale.service.audit.latex.ProjectDataAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.persistence.store.StorageException;

public class CloneMetricsTableCreator
extends LatexTableCreatorBase {
    public CloneMetricsTableCreator(EAuditExportLanguage language, ProjectDataAccessor mainProjectAccessor, ProjectDataAccessor ... subProjectDataAccessors) {
        super(language, mainProjectAccessor, subProjectDataAccessors);
    }

    @Override
    protected String getTableContent() throws StorageException {
        this.logErrorsForDisabledCloningGroup();
        return this.getNumberOfClones() + this.getLongestClone() + this.getMostFrequentClone() + "\\midrule \n" + this.getCloneCoverage() + "\\bottomrule \n";
    }

    private static boolean isCloningGroupEnabled(ProjectDataAccessor accessor) {
        return accessor.isAnalysisGroupEnabled("Code Clones");
    }

    private void logErrorsForDisabledCloningGroup() {
        for (ProjectDataAccessor accessor : this.projectDataAcessors) {
            if (CloneMetricsTableCreator.isCloningGroupEnabled(accessor)) continue;
            LogManager.getLogger().warn("The analysis group 'Clones' is not enabled for the project '" + String.valueOf(accessor.getProjectId()) + "'.");
        }
    }

    @Override
    protected String getLabel() {
        return "tab:redundancy";
    }

    @Override
    protected String getName() {
        return this.getMessage(EAuditMessageKey.REDUNDANCY_METRICS);
    }

    @Override
    protected String getColumnDefinition() {
        return "\\begin{tabular}{l" + StringUtils.repeat((String)"r", (int)this.projectDataAcessors.length) + "} \\toprule \n";
    }

    @Override
    protected String getTableColumns() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMetricHeader());
        for (ProjectDataAccessor accessor : this.projectDataAcessors) {
            builder.append(" & \\ctextbf{").append(accessor.getProjectAlias()).append("}");
        }
        builder.append(" \\\\ \n").append("\\midrule\n");
        return builder.toString();
    }

    protected String getCloneCoverage() {
        StringBuilder builder = new StringBuilder(this.getMessage(EAuditMessageKey.CLONE_COVERAGE_METRIC)).append(" & ");
        for (int i = 0; i < this.projectDataAcessors.length; ++i) {
            builder.append(this.getCloneCoverageText(this.projectDataAcessors[i]));
            if (i >= this.projectDataAcessors.length - 1) continue;
            builder.append(" & ");
        }
        builder.append(" \\\\ \n");
        return builder.toString();
    }

    private static boolean isCloneCoverageMetricEnabled(ProjectDataAccessor accessor) {
        return accessor.isMetricEnabled("Code Clones", "Clone Coverage");
    }

    private String getCloneCoverageText(ProjectDataAccessor accessor) {
        if (!CloneMetricsTableCreator.isCloneCoverageMetricEnabled(accessor)) {
            CloneMetricsTableCreator.logMetricDisabledWarning(accessor, "Clone Coverage");
            return "disabled";
        }
        return this.getPercentageFromDouble(accessor.getNumberMetricValue("Clone Coverage"));
    }

    protected String getMostFrequentClone() throws StorageException {
        String[] cloneMetrics = new String[this.projectDataAcessors.length];
        for (int i = 0; i < this.projectDataAcessors.length; ++i) {
            cloneMetrics[i] = this.projectDataAcessors[i].getMostFrequentCloneMetric().toString();
        }
        return CloneMetricsTableCreator.createTableRow(this.getMessage(EAuditMessageKey.MOST_FREQUENT_CLONE_METRIC), cloneMetrics);
    }

    protected String getLongestClone() throws StorageException {
        String[] cloneMetrics = new String[this.projectDataAcessors.length];
        for (int i = 0; i < this.projectDataAcessors.length; ++i) {
            cloneMetrics[i] = this.projectDataAcessors[i].getLongestCloneMetric().toString();
        }
        return CloneMetricsTableCreator.createTableRow(this.getMessage(EAuditMessageKey.LONGEST_CLONE_METRIC), cloneMetrics);
    }

    protected String getNumberOfClones() throws StorageException {
        String[] cloneMetrics = new String[this.projectDataAcessors.length];
        for (int i = 0; i < this.projectDataAcessors.length; ++i) {
            cloneMetrics[i] = this.projectDataAcessors[i].getNumberOfClones().toString();
        }
        return CloneMetricsTableCreator.createTableRow(this.getMessage(EAuditMessageKey.NUMBER_OF_CLONES_METRIC), cloneMetrics);
    }
}

