/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.latex;

import com.teamscale.service.audit.EAuditExportLanguage;
import com.teamscale.service.audit.EAuditMessageKey;
import com.teamscale.service.audit.latex.LatexTableCreatorBase;
import com.teamscale.service.audit.latex.ProjectDataAccessor;
import org.apache.commons.lang3.StringUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class CommentTableCreator
extends LatexTableCreatorBase {
    public CommentTableCreator(EAuditExportLanguage language, ProjectDataAccessor mainAccessor, ProjectDataAccessor ... accessors) {
        super(language, mainAccessor, accessors);
    }

    @Override
    protected String getTableContent() {
        return this.getTypeComments() + this.getMethodComments() + this.getAttributeComments() + "\\midrule\n" + this.getComments() + "\\bottomrule \n";
    }

    private static boolean isCommentCompletenessMetricEnabled(ProjectDataAccessor accessor, String metricName) {
        return accessor.isMetricEnabled("Comment Completeness", metricName);
    }

    @Override
    protected String getLabel() {
        return "tab:comments";
    }

    @Override
    protected String getName() {
        return this.getMessage(EAuditMessageKey.MISSING_COMMENTS_METRICS);
    }

    protected String getLatexTikzBarChart(Assessment assessment) {
        CCSMAssert.isTrue((assessment.getColorFrequency(ETrafficLightColor.YELLOW) == 0 ? 1 : 0) != 0, (String)"Comment assessment contained yellow color but should have contained only red and green.");
        double red = (double)assessment.getColorFrequency(ETrafficLightColor.RED) / (double)assessment.getSize();
        if (Double.isNaN(red)) {
            return "-";
        }
        return "\\incellassessment{" + red + "}{0.0}";
    }

    private String getComments() {
        return this.getCommentsMetric(this.getMessage(EAuditMessageKey.ALL_COMMENTS_METRIC), "Comment Completeness Assessment");
    }

    protected String getAttributeComments() {
        return this.getCommentsMetric(this.getMessage(EAuditMessageKey.ATTRIBUTE_COMMENTS_METRIC), "Comment Completeness Assessment for Attributes");
    }

    protected String getMethodComments() {
        return this.getCommentsMetric(this.getMessage(EAuditMessageKey.METHOD_COMMENTS_METRIC), "Comment Completeness Assessment for Methods");
    }

    protected String getTypeComments() {
        return this.getCommentsMetric(this.getMessage(EAuditMessageKey.TYPE_COMMENTS_METRIC), "Comment Completeness Assessment for Types");
    }

    private String getCommentsMetric(String label, String commentMetricName) {
        String[] assessments = new String[this.projectDataAcessors.length];
        for (int i = 0; i < this.projectDataAcessors.length; ++i) {
            assessments[i] = this.getAssessmentText(this.projectDataAcessors[i], commentMetricName);
        }
        return CommentTableCreator.createTableRow(label, assessments);
    }

    private String getAssessmentText(ProjectDataAccessor accessor, String commentMetricName) {
        if (!CommentTableCreator.isCommentCompletenessMetricEnabled(accessor, commentMetricName)) {
            CommentTableCreator.logMetricDisabledWarning(accessor, commentMetricName);
            return "disabled & disabled";
        }
        Assessment assessment = accessor.getAssessmentMetricValue(commentMetricName);
        double redPercentage = (double)assessment.getColorFrequency(ETrafficLightColor.RED) / (double)assessment.getSize();
        return this.getPercentageFromDouble(redPercentage) + " \\% & " + this.getLatexTikzBarChart(assessment);
    }

    @Override
    protected String getColumnDefinition() {
        return "\\begin{tabular}{l" + StringUtils.repeat((String)"lr", (int)this.projectDataAcessors.length) + "} \\toprule \n";
    }

    @Override
    protected String getTableColumns() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMetricHeader());
        for (ProjectDataAccessor accessor : this.projectDataAcessors) {
            builder.append(" & \\multicolumn{2}{c}{\\textbf{").append(accessor.getProjectAlias()).append("}}");
        }
        builder.append(" \\\\ \n\\midrule\n");
        return builder.toString();
    }
}

